import functools


def path_filter_template(prefix, template, path):
    if path == prefix[:-1]:
        return False
    template = template.split("/")
    path = path[len(prefix):].split("/")
    if len(template) != len(path):
        return False
    for template_part, path_part in zip(template, path):
        if (template_part != "*") and (template_part != path_part):
            return False
    return True


def subtree_filter_template(prefix, template, subtree, *args):
    if subtree == prefix[:-1]:
        return True
    template = template.split("/")
    subtree = subtree[len(prefix):].split("/")
    if len(subtree) > len(template):
        return False
    for template_part, subtree_part in zip(template, subtree):
        if (template_part != "*") and (template_part != subtree_part):
            return False
    return True


def unfold_template(yt_client, template):
    if "*" not in template.split("/"):
        return [template]
    prefix = yt_client.config["prefix"]
    path_filter = functools.partial(path_filter_template, prefix, template)
    subtree_filter = functools.partial(subtree_filter_template, prefix, template)
    return [node[len(prefix):] for node in yt_client.search("", path_filter=path_filter, subtree_filter=subtree_filter)]
