from __future__ import absolute_import
import os
import time
import uuid


def to_absolute_path(path):
    return path if path.startswith("/") else "//{}".format(path)


class YtTempDir(object):
    def __init__(self, yt_client, root_temp_dir):
        self.root_temp_dir = root_temp_dir
        self.yt_client = yt_client
        self.path = None
        self.transaction = None

    def __enter__(self):
        self.transaction = self.yt_client.Transaction()
        self.transaction.__enter__()

        while not self.path or self.yt_client.exists(to_absolute_path(self.path)):
            self.path = os.path.join(
                self.root_temp_dir,
                "{}-{}".format(uuid.uuid4(), int(time.time()))
            )

        self.yt_client.create('map_node', self.path, recursive=True)

        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if self.path is not None and exc_type is None:
            self.yt_client.remove(to_absolute_path(self.path), recursive=True, force=True)

        self.transaction.__exit__(exc_type, exc_val, exc_tb)
