import datetime
from crypta.lib.python.yt import yt_helpers

CREATION_TIME = 'creation_time'
EXPIRATION_TIME = 'expiration_time'
DATETIMME_FORMAT = '%Y-%m-%dT%H:%M:%S.%fZ'


class ThinOutHistoricalData(object):
    def __init__(self, config, yt):
        self.config = config
        self.yt = yt
        self.initial_datetime = datetime.datetime.strptime('1970-01-01T00:00:00.0Z', DATETIMME_FORMAT)

    def get_creation_time(self, table):
        return datetime.datetime.strptime(self.yt.get_attribute(table, CREATION_TIME), DATETIMME_FORMAT)

    def get_expiration_time(self, table):
        return datetime.datetime.strptime(self.yt.get_attribute(table, EXPIRATION_TIME), DATETIMME_FORMAT)

    def get_boundary(self, index, creation_time):
        # calculate how many tables to check for long_ttl taking into account that some dates may be missed in the folder
        count = 1
        while (len(self.present_tables) > (index + count) and
               (self.get_creation_time(self.present_tables[index + count]) - creation_time).days <= self.config.ThinOutDays):
            count += 1

        return index + count

    def _process_table(self, index, table):
        creation_time = self.get_creation_time(table)

        if (creation_time - self.initial_datetime).days % self.config.ThinOutDays == 0:
            yt_helpers.set_ttl(table, datetime.timedelta(days=self.config.LongTtlDays), yt_client=self.yt)

        elif (index + self.config.ThinOutDays) >= len(self.present_tables):
            yt_helpers.set_ttl(table, datetime.timedelta(days=self.config.ShortTtlDays), yt_client=self.yt)

        else:
            long_ttl_present = False
            # check if there was long_ttl table within the current period
            for i in range(index + 1, self.get_boundary(index, creation_time)):
                if (self.get_expiration_time(self.present_tables[i]) - self.get_creation_time(self.present_tables[i])) == datetime.timedelta(days=self.config.LongTtlDays):
                    long_ttl_present = True

            if long_ttl_present:
                yt_helpers.set_ttl(table, datetime.timedelta(days=self.config.ShortTtlDays), yt_client=self.yt)
            else:
                yt_helpers.set_ttl(table, datetime.timedelta(days=self.config.LongTtlDays), yt_client=self.yt)

    def thin_out(self, transaction):
        self.yt.COMMAND_PARAMS['transaction_id'] = str(transaction.transaction_id)
        self.present_tables = self.yt.list(self.config.DailyFolder, absolute=True)
        self.present_tables.sort()

        for index in range(len(self.present_tables) - 1, -1, -1):
            if not self.yt.has_attribute(self.present_tables[index], EXPIRATION_TIME):
                self._process_table(index, self.present_tables[index])
