import contextlib

import kazoo.client
from zake import fake_client


@contextlib.contextmanager
def zk_client(hosts, port):
    """Return connection to zookeeper.
    Uses hosts and port from :module:`conf`."""
    zk_hosts = ','.join('%s:%s' % (host, port) for host in hosts)
    zk = kazoo.client.KazooClient(zk_hosts)
    zk.start()
    try:
        yield zk
    except Exception:
        raise
    finally:
        zk.stop()


@contextlib.contextmanager
def fake_zk_client():
    """Return faked zookeeper connection.
    Useful for testing and local runs of something distributed.
    """
    fzk = fake_client.FakeClient()
    fzk.start()
    try:
        yield fzk
    except Exception:
        raise
    finally:
        fzk.stop()
