import logging
import os

from library.python.testing.recipe import (
    declare_recipe,
    set_env
)
import retry
from yatest.common import network

from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.juggler.test_utils.mock_juggler_server import MockJugglerServer


PID_FILE = "juggler_push_api.pid"


def start(_):
    logging_helpers.configure_stdout_logger(logging.getLogger())

    pm = network.PortManager()
    server = MockJugglerServer()
    server.port = pm.get_port()

    set_env("JUGGLER_PUSH_URL_PREFIX", server.url_prefix)

    pid = os.fork()
    if pid == 0:
        server._run()
    else:
        retry.retry_call(server._ping_exc, tries=30, delay=1)

        with open(PID_FILE, "w") as f:
            f.write(str(pid))


def stop(_):
    with open(PID_FILE) as f:
        pid = int(f.read())
        os.kill(pid, 9)


def main():
    declare_recipe(start, stop)
