import os

from library.python.testing import recipe
import requests
import retry
import six
import yaml
import yatest.common
from yatest.common import network

from crypta.utils.rtmr_resource_service.bin.server.testutils import setup
from crypta.utils.rtmr_resource_service.bin.server.testutils.crypta_resource_service import CryptaResourceService
from crypta.lib.python.yt.local_tests import local_clusters
from crypta.lib.python.yt.local_tests.yt_replicated_dyntables import YtReplicatedDyntables


def get_pid_file():
    return os.path.join(recipe.ya.output_dir, "resource_service_mock.pid")


@retry.retry(tries=300, delay=0.1)
def wait_until_up(url_prefix):
    response = requests.get(url_prefix + "/ping")
    assert response.ok, response.content


def run(port):
    with open(yatest.common.source_path(os.environ["RESOURCE_SERVICE_CONFIG_PATH"])) as f:
        config = yaml.safe_load(f)

    cluster_name = "localhost"
    yt = local_clusters.start_local_clusters([cluster_name])[cluster_name]

    yt_kv = YtReplicatedDyntables(yt)
    public_resources = [
        (resource, env, version)
        for env, resources in six.iteritems(config["db-state"])
        for resource, version in six.iteritems(resources)
    ]
    setup.setup(yt_kv, config["dcs"], public_resources)

    with network.PortManager() as pm:
        with CryptaResourceService(
            yt_kv,
            yatest.common.output_path("resource_service_mock"),
            os.path.join(os.getenv("RESOURCE_SERVICE_FILE_ROOT_PREFIX", yatest.common.source_path()), config["file_client"]["root"]),
            port,
            config["resources"],
            pm.get_port(),
        ) as service:
            service.process.wait()


def start(_):
    pm = network.PortManager()
    host = "localhost"
    port = pm.get_port()
    url_prefix = "http://{host}:{port}".format(host=host, port=port)

    recipe.set_env("RESOURCE_SERVICE_URL_PREFIX", url_prefix)

    pid = os.fork()
    if pid == 0:
        run(port)
    else:
        with open(get_pid_file(), "w") as f:
            f.write(str(pid))
        wait_until_up(url_prefix)


def stop(_):
    with open(get_pid_file()) as f:
        pid = int(f.read())
        os.kill(pid, 9)


def main():
    recipe.declare_recipe(start, stop)
