import argparse
import logging
import os

import flask
from library.python.testing.recipe import declare_recipe, set_env
import yatest.common
from yatest.common import network

from crypta.lib.python.logging import logging_helpers

PID_FILE = "sandbox_proxy.pid"

PORT_MANAGER = network.PortManager()


def create_app(test_dir):
    app = flask.Flask(__name__)

    @app.route('/<path:path>')
    def send_file(path):
        return flask.send_from_directory(test_dir, path)

    @app.errorhandler(404)
    def page_not_found(_):
        return flask.make_response("Not found", 404)

    return app


def parse_args(argv):
    parser = argparse.ArgumentParser(description='Sandbox API mock server')
    parser.add_argument('--path', help='Config file', required=True)
    return parser.parse_args(argv)


def run(host, port, argv):
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = parse_args(argv)

    app = create_app(yatest.common.source_path(args.path))
    app.logger.info('--- START SERVER ---')
    app.run(host, port)


def start(argv):
    host = "localhost"
    port = PORT_MANAGER.get_port()

    set_env("SANDBOX_PROXY_URL_PREFIX", "http://{host}:{port}".format(host=host, port=port))

    pid = os.fork()
    if pid == 0:
        run(host, port, argv)
    else:
        with open(PID_FILE, "w") as f:
            f.write(str(pid))


def stop(_):
    with open(PID_FILE) as f:
        pid = int(f.read())
        os.kill(pid, 9)

    PORT_MANAGER.release()


def main():
    declare_recipe(start, stop)
