import sys
import subprocess
import os
import itertools

def isplit(iterable, splitters):
    return [
        list(g)
        for k, g in itertools.groupby(
            iterable, lambda x: x in splitters
        )
        if not k
    ]

env = os.environ.copy()

arg_parts = isplit(sys.argv[1:], ('--', '&&'))
custom_env, programs = arg_parts[0], arg_parts[1:]

for each in custom_env:
    k, v = each.split('=', 1)
    env[k] = v

for program in programs:
    subprocess.check_call(program, env=env)
