#include "common.h"

#include <crypta/lib/native/time/shifted_clock.h>
#include <crypta/lib/native/yt/utils/helpers.h>
#include <crypta/lookalike/lib/native/get_date.h>

bool NCrypta::NLookalike::IsProcessed(NYT::IClientBasePtr client, const TString& path) {
    TString date = GetDate(TShiftedClock::Now());
    return client->Exists(GetPathWithAttribute(path, LAST_PROCESSED_ATTR_NAME)) && GetAttribute(client, path, LAST_PROCESSED_ATTR_NAME) == date;
}

