#include "directory_finder.h"

#include <mapreduce/yt/util/ypath_join.h>
#include <util/generic/algorithm.h>
#include <util/generic/hash_set.h>
#include <util/generic/string.h>

using namespace NCrypta::NLookalike;

TString NDirectoryFinder::FindLastWithChildren(NYT::IClientBasePtr client, const TString& path, const TVector<TString>& requiredChildren) {
    static const TString TYPE = "type";

    TVector<TString> subDirectories;

    const auto listWithType = NYT::TListOptions().AttributeFilter(NYT::TAttributeFilter().AddAttribute(TYPE));

    for (const auto& node : client->List(path, listWithType)) {
        if (node.GetAttributes()[TYPE].AsString() == "map_node") {
            subDirectories.push_back(node.AsString());
        }
    }

    Sort(subDirectories, [](const auto& left, const auto& right) { return left > right; });

    for (const auto& subDirectory : subDirectories) {
        const auto& subDirectoryPath = NYT::JoinYPaths(path, subDirectory);
        const auto& nodes = client->List(subDirectoryPath);

        THashSet<TString> children;
        Transform(nodes.begin(), nodes.end(), std::inserter(children, children.begin()), [](const auto& node) { return node.AsString(); });

        if (AllOf(requiredChildren, [&](const auto& requiredChild){ return children.contains(requiredChild); })) {
            return subDirectoryPath;
        }
    }

    ythrow yexception() << "No matching directories found in " << path;
}
