#include "common.h"
#include "embedding_model.h"

#include <crypta/lib/native/features_calculator/features_calculator.h>

#include <kernel/dssm_applier/nn_applier/lib/layers.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_value.h>
#include <util/generic/string.h>
#include <util/stream/file.h>

using namespace NCrypta::NLookalike;

TEmbeddingModel::TEmbeddingModel(const TString& modelFileName)
    : DssmModel(NNeuralNetApplier::TModel::FromFile(modelFileName)) {
}

NCrypta::TFeaturesMapping TEmbeddingModel::GetFeaturesMapping(const TString& fileName) {
    TFileInput inSegments(fileName);
    NJson::TJsonValue segmentsJson;
    NJson::ReadJsonTree(&inSegments, &segmentsJson);
    NCrypta::TFeaturesMapping featuresMapping;
    for (const auto& elem : segmentsJson.GetMapSafe()) {
        featuresMapping[elem.first] = elem.second.GetIntegerSafe();
    }
    return featuresMapping;
}
