#include "get_oldest_timed_table.h"
#include <mapreduce/yt/util/ypath_join.h>

TMaybe<TString> NCrypta::NLookalike::GetOldestTimedTable(NYT::IClientBasePtr client, const NYT::TYPath& directory) {
    const auto& tables = client->List(directory);

    if (tables.size() == 0) {
        return Nothing();
    }

    TVector<TString> paths;
    for (const auto& table: tables) {
        paths.push_back(table.AsString());
    }

    std::sort(paths.begin(), paths.end());

    return paths[0];
}
