#include "goal_type_converter.h"

using namespace NCrypta;
using namespace NLookalike;

TLalParent::EType NCrypta::NLookalike::NGoalTypeConverter::ConvertRetargetingIdTypeToLalParentType(NRetargetingIds::EType type) {
    if (type == NRetargetingIds::EType::MetrikaGoal) {
        return TLalParent::GOAL;
    } else if (type == NRetargetingIds::EType::MetrikaAudienceSegment) {
        return TLalParent::AUDIENCE_SEGMENT;
    } else if (type == NRetargetingIds::EType::MetrikaSegment) {
        return TLalParent::METRIKA_SEGMENT;
    } else if (type == NRetargetingIds::EType::MetrikaCounter) {
        return TLalParent::METRIKA_COUNTER;
    } else if (type == NRetargetingIds::EType::MetrikaEcommerce) {
        return TLalParent::METRIKA_ECOMMERCE;
    } else if (type == NRetargetingIds::EType::MobileEvent) {
        return TLalParent::MOBILE_EVENT;
    } else if (type == NRetargetingIds::EType::CdpSegment) {
        return TLalParent::CDP_SEGMENT;
    }
    return TLalParent::UNSUPPORTED;
}

NRetargetingIds::EType NCrypta::NLookalike::NGoalTypeConverter::ConvertLalParentTypeToRetargetingIdType(TLalParent::EType type) {
    if (type == TLalParent::GOAL) {
        return NRetargetingIds::EType::MetrikaGoal;
    } else if (type == TLalParent::AUDIENCE_SEGMENT) {
        return NRetargetingIds::EType::MetrikaAudienceSegment;
    } else if (type == TLalParent::METRIKA_SEGMENT) {
        return NRetargetingIds::EType::MetrikaSegment;
    } else if (type == TLalParent::METRIKA_COUNTER) {
        return NRetargetingIds::EType::MetrikaCounter;
    } else if (type == TLalParent::METRIKA_ECOMMERCE) {
        return NRetargetingIds::EType::MetrikaEcommerce;
    } else if (type == TLalParent::MOBILE_EVENT) {
        return NRetargetingIds::EType::MobileEvent;
    } else if (type == TLalParent::CDP_SEGMENT) {
        return NRetargetingIds::EType::CdpSegment;
    }
    return NRetargetingIds::EType::Unknown;
}
