#include "hnsw_index_model.h"

using namespace NCrypta::NLookalike;

NCrypta::NLookalike::THnswIndexModel::THnswIndexModel(size_t dimension, const TString& indexFile, const TString& dataFile, const TString& labelsFile, size_t topSize, size_t searchNeighborhoodSize)
    : Dimension(dimension)
    , IndexBlob(TBlob::FromFile(indexFile))
    , DataBlob(TBlob::FromFile(dataFile))
    , LabelsBlob(TBlob::FromFile(labelsFile))
    , Labels(static_cast<const TLabel*>(LabelsBlob.Data()), LabelsBlob.Size() / sizeof(TLabel))
    , Index(IndexBlob, DataBlob, Dimension)
    , TopSize(topSize)
    , SearchNeighborhoodSize(searchNeighborhoodSize)
{
}
