#pragma once

#include <crypta/lookalike/lib/native/common.h>

#include <library/cpp/hnsw/index/dense_vector_distance.h>
#include <library/cpp/hnsw/index/dense_vector_index.h>

#include <util/generic/array_ref.h>
#include <util/generic/string.h>

namespace NCrypta::NLookalike {
    class THnswIndexModel {
    public:
        using TDistance = NHnsw::TDotProduct<TEmbeddingComponent>;
        using TIndex = NHnsw::THnswDenseVectorIndex<TEmbeddingComponent>;
        using TNeighbors = TVector<TIndex::TNeighbor<TDistance::TResult>>;
        using TLabel = ui64;
        using TLabels = TVector<TLabel>;

        THnswIndexModel(size_t dimension, const TString& indexFile, const TString& dataFile, const TString& labelsFile, size_t topSize, size_t searchNeighborhoodSize);

        template<typename TEmbeddingContainer>
        TNeighbors Retrieve(const TEmbeddingContainer& origin) {
            auto neighbors = Index.GetNearestNeighbors<TDistance>(origin.data(), TopSize, SearchNeighborhoodSize);

            for (auto& neighbor : neighbors) {
                neighbor.Id = Labels.at(neighbor.Id);
            }

            return neighbors;
        }

    private:
        size_t Dimension = 0;

        TBlob IndexBlob;
        TBlob DataBlob;
        TBlob LabelsBlob;

        TConstArrayRef<TLabel> Labels;
        TIndex Index;

        size_t TopSize = 0;
        size_t SearchNeighborhoodSize = 0;
    };

}
