#include "normalize.h"

#include <library/cpp/dot_product/dot_product.h>

#include <util/generic/vector.h>

#include <utility>

namespace {
    static const float EPS = 1e-9;

    double ComputeNorm(const TVector<float>& vector) {
        return sqrt(DotProduct(vector.begin(), vector.begin(), vector.size()));
    }
}

using namespace NCrypta::NLookalike;

void NCrypta::NLookalike::Normalize(TVector<float>& vector) {
    double norm = ComputeNorm(vector);
    for (auto& value : vector) {
        value /= (norm + EPS);
    }
}
