#include "pqlib_producer_initializer.h"
#include <crypta/lib/native/pqlib/credentials_provider.h>
#include <crypta/lib/native/pqlib/logger.h>
#include <crypta/lib/native/pqlib/pqlib.h>

using namespace NCrypta::NLookalike;
using namespace NCrypta::NPQ;

THolder<TProducer> NCrypta::NLookalike::GetPqlibProducer(TWriterConfig config) {
    auto pqLib = NPQLib::Create(config.GetPqlib());
    auto credentialsProvider = NCredentialsProvider::Create(config.GetCredentials(), NLogger::Create("pqlib"));
    return MakeHolder<TProducer>(pqLib, config.GetProducer(), credentialsProvider, TStats::TSettings());
}
