#pragma once

#include "common.h"
#include "embedding_model.h"
#include "segment_features_calculator.h"

#include <crypta/lib/proto/user_data/user_data_stats.pb.h>

#include <util/generic/string.h>

namespace NCrypta::NLookalike {
    class TSegmentEmbeddingModel : public TEmbeddingModel {
    public:
        TSegmentEmbeddingModel(const TString& modelFileName, const TString& featuresMappingFileName);

        TEmbedding Embed(const NLab::TUserDataStats& segment) const;

    private:
        TSegmentFeaturesCalculator SegmentFeaturesCalculator;
    };
}
