#pragma once

#include "common.h"

#include <crypta/lib/native/features_calculator/features_calculator.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>

#include <util/generic/string.h>

namespace NCrypta::NLookalike {
    class TSegmentFeaturesCalculator : public TFeaturesCalculator {
    public:
        TSegmentFeaturesCalculator(TFeaturesMapping featuresMapping);

        TString PrepareFloatFeatures(const NLab::TUserDataStats& segment) const;

        static TString PrepareAffinitiveSitesIds(const NLab::TUserDataStats& segment);

        static TString PrepareAffinitiveApps(const NLab::TUserDataStats& segment);

    private:
        static const size_t SegmentsAffinitiveSitesN = 20;
        static const size_t SegmentsAffinitiveAppsN = 20;
    };
}
