from util.generic.hash cimport THashMap
from util.generic.string cimport TString


cdef extern from 'crypta/lib/proto/user_data/user_data_stats.pb.h' namespace 'NLab' nogil:
    cdef cppclass TUserDataStats:
        bint ParseFromString(const TString& data)


cdef extern from 'crypta/lookalike/lib/native/segment_features_calculator.h' namespace 'NCrypta::NLookalike' nogil:
    cdef cppclass TSegmentFeaturesCalculator:
        TSegmentFeaturesCalculator(const THashMap[TString, size_t]& featuresMapping) except +

        TString PrepareFloatFeatures(const TUserDataStats& segment) except +
        TString PrepareAffinitiveSitesIds(const TUserDataStats& segment) except +
        TString PrepareAffinitiveApps(const TUserDataStats& segment) except +
