#include "common.h"
#include "prepare_test_data.h"

#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/lookalike/lib/native/common.h>
#include <crypta/lookalike/lib/native/segment_embedding_model.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NCrypta::NLookalike;

namespace {
    static const NLab::TUserDataStats userDataStats = PrepareTestSegmentData();
    static const TSegmentEmbeddingModel segmentEmbeddingModel(DSSM_MODEL_FILE_NAME, SEGMETS_DICT_FILE_NAME);
}

Y_UNIT_TEST_SUITE(TSegmentEmbeddingModel) {
    Y_UNIT_TEST(Embed) {
        TEmbedding segmentEmbedding = segmentEmbeddingModel.Embed(userDataStats);
        TEmbedding reference = {0.0132155, 0.00822992, 0.000351523, -0.00736778, -0.0313369, 0.0125906, -0.00877126, 0.00433798, -0.0551706, -0.0633728, -0.132029, 0.027156, -0.0114236, -0.0276462, -0.0301568, 0.0224705, 0.0185018, 0.044206, 0.0611149, -0.00824462, 0.0486655, 0.00197494, 0.0212218, -0.0169818, 0.0391049, 0.0289599, -0.0430315, 0.00917022, -0.024112, -0.017898, 0.0893406, -0.0517515, -0.0143641, -0.0221941, -0.101021, -0.00906063, -0.0442485, 0.036348, 0.0694401, 0.00330507, 0.0841449, 0.060697, 0.038727, -0.0169121, -0.0555346, 0.0556124, 0.0103332, -0.077905, -0.00311457, -0.0104779, 0.0284736, -0.00952805, -0.0473546, 0.00662678, -0.0370228, -0.005666, 0.0276479, -0.093651, -0.0765462, 0.00894533, 0.0265215, 0.00538329, -0.0197367, 0.0695587, -0.0185002, -0.0490078, -0.0169816, 0.000620994, 0.0513982, -0.00216528, 0.016624, 0.0299996, -0.0501875, -0.00369157, -0.0368587, -0.0103753, 0.000267758, -0.0475643, 0.0335163, 0.00634261, -0.00278526, -0.0437814, -0.102047, 0.0143509, -0.0160747, 0.00233241, 0.0164072, 0.0465013, 0.0327508, -0.0539119, 0.00480079, -0.0394884, -0.0326094, 0.00968672, -0.0174526, 0.0080617, -0.00192975, -0.0336106, -0.0259442, -0.025449, -0.0270649, 0.00672597, 0.0344209, 0.0172205, 0.0989777, 0.00607946, 0.0154381, 0.0435654, 0.0321309, 0.00500411, 0.013201, 0.0453683, 0.0672875, -0.0121723, 0.0434906, -0.0478001, -0.0621279, -0.013644, 0.0225326, 0.0323061, 0.0526707, 0.020224, -0.0828493, -0.0393264, 0.0552406, 0.0315678, -0.0220699, -0.00396191, 0.00886913, -0.0102028, -0.0491192, -0.103641, -0.0317034, -0.0344011, 0.0434541, 0.0650956, -0.0134314, -0.00814924, -0.0247011, 0.0293005, -0.0594799, -0.0206965, 0.0225092, -0.0378986, -0.0417671, -0.00325554, -0.010029, 0.125445, 0.0080808, -0.0140446, 0.00523232, -0.00931292, 0.00920549, 0.0179397, -0.0634814, -0.028608, -0.0109869, -0.0163034, 0.00160805, 0.0175385, -0.0666302, 0.0326106, 0.00838807, -0.0195898, 0.193033, -0.00954086, 0.00239976, -0.0192906, 0.0533383, 0.000737703, 0.0270444, -0.0822944, -0.062499, 0.020641, -0.0178129, 0.0661113, 0.0285516, 0.0909164, 0.0284615, 0.00925073, -0.0442598, 0.0329687, 0.0652553, 0.0144249, 0.045904, -0.0227232, 0.0402301, -0.00133797, 0.116193, 0.0752784, 0.0502573, -0.0666523, -0.0342363, 0.0212131, -0.0475417, 0.018338, 0.0332535, -0.0155407, -0.0547455, 0.0163927, -0.049188, -0.0206464, -0.0675393, 0.00580682, -0.0413047, 0.0226643, -0.00222873, -0.00392541, 0.0260251, -0.0203804, 0.143571, -0.11218, -0.0291814, 0.00821493, -0.0385061, -0.000901826, 0.0446041, -0.0797535, -0.0501071, -0.13964, 0.0280692, 0.0513448, -0.00947172, -0.0501179, 0.0374001, 0.0356503, -0.0105687, 0.0442006, 0.00469077, -0.00405634, -0.0843556, 0.00779619, 0.0310438, -0.028898, -0.00898235, 0.0145044, -0.000295054, -0.099582, -0.0568269, 0.0609477, 0.0228612, -0.0262988, -0.0162328, -0.0659769, -0.123393, -0.00481001, -0.110448, -0.0246581, -0.0234377, -0.0548148, 0.0094766, 0.105529, 0.00414885, -0.00503214, 0.0199572, 0.0653593, -0.00551745, -0.0165065, 0.0295806, 0.0219995, -0.0146801, -0.0319796, -0.00624986, -0.0416403, -0.0833694, -0.0738836, -0.199878, -0.0226125, -0.0530876, -0.063943, 0.018442, -0.0547609, -0.0494553, 0.0112928, 0.00578742, -0.0489053, 0.0232703, -0.00448115, -0.0886215, 0.0333752, -0.0591378, -0.0698876, -0.0246191, -0.00968837, -0.0340264, -0.0234454, 0.0147034, -0.0259422, -0.0505832, 0.0111244, 0.0579245, 0.00101301, 0.0240522, 0.0259704, 0.0156243, 0.0957391, -0.137129, 0.0146963, -0.0614145, -0.0150162, 0.0703037, -0.0661315, -0.0643371, 0.209153, 0.0783085, -0.0126106, -0.0481773, -0.0451358, -0.00670836, -0.00356081, 0.0372962, 0.0933548, -0.0728983, -0.00590627, -0.0121105, 0.0262105, 0.00136909, -0.0254202, 0.0392807, -0.0123636, -0.0948588, 0.0351354, 0.0493787, -0.0269874, 0.0332114, 0.0191755, -0.029888, -0.00937182, 0.0111946, -0.0513059, -0.00615673, -0.0931089, 0.0210358, -0.0372653, -0.0183119, -0.0765737, 0.00929405, 0.0112592, -0.0322843, -0.075631, -0.00429097, -0.0267926, 0.022882, 0.0678341, -0.0596799, 0.0122094, 0.00393312, 0.0219839, 0.0574888, 0.0186633, 0.094308, 0.0694026, 0.0247524, -0.042515, -0.0512181, -0.0852381, -0.0127781, 0.0464585, -0.00974411, -0.0138837, -0.0450728, 0.0479814, 0.00655755, -0.0153548, -0.0449563, -0.0121273, -0.0558701, 0.0240507, -0.00383393, -0.0779648, -0.00107608, -0.0761303, -0.0182329, 0.026558, 0.0210441, 0.0223302, 0.0395391, 0.0701795, -0.0639855, -0.0203523, 0.0312541, 0.118072, -0.0323495, -0.0237703, -0.104665, -0.111728, 0.00869183, 0.0571494, 0.0177664, 0.0292994, -0.013589, -0.058762, -0.0864633, -0.0122833, -0.00906206, 0.132888, 0.0479162, -0.0235001, -0.0323159, 0.0942175};
        UNIT_ASSERT_EQUAL(segmentEmbedding.size(), reference.size());
        AssertFloatVectorsEqual(segmentEmbedding, reference);
    }

    Y_UNIT_TEST(MissingDistributions) {
        auto badStats = userDataStats;
        badStats.ClearDistributions();

        UNIT_ASSERT_EXCEPTION_CONTAINS(segmentEmbeddingModel.Embed(badStats), yexception, "expected size");
    }
}
