#include "common.h"
#include "prepare_test_data.h"

#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/lookalike/lib/native/common.h>
#include <crypta/lookalike/lib/native/user_embedding_model.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NCrypta::NLookalike;

namespace {
    static const NLab::TUserData userData = PrepareTestUserData();
    static const TUserEmbeddingModel userEmbeddingModel(DSSM_MODEL_FILE_NAME, SEGMETS_DICT_FILE_NAME);
}

Y_UNIT_TEST_SUITE(TUserEmbeddingModel) {
    Y_UNIT_TEST(Embed) {
        TEmbedding userEmbedding = userEmbeddingModel.Embed(userData);
        TEmbedding reference = {0.0161631, -0.0205488, -0.016089, -0.0430227, 0.0144671, 0.0606647, 0.00182657, -0.0145181, 0.0137187, -0.0307782, -0.0663094, 0.0385311, 0.0289118, -0.0241253, 0.0193527, 0.0231141, -0.0469381, -0.00330775, 0.00495496, 0.000933893, 0.00560882, -0.0415924, 0.0364444, 0.00438577, -0.00862334, 0.0924272, -0.044451, -0.0157258, 0.0222197, 0.0115831, 0.0833562, -0.0658294, 0.0162012, -0.0262481, -0.0394372, -0.00691078, -0.0272334, -0.0217964, -0.000965625, 0.0391632, 0.0347249, 0.0668545, 0.0320815, -0.0234316, 0.0165221, -0.000719706, -0.0201911, 0.00237178, 0.0107881, 0.000413177, -0.0109976, -0.016996, 0.0107025, 0.0148795, -0.00443841, 0.0111347, 0.00929541, -0.0239917, -0.0368837, -0.0317188, 0.00808716, -0.0155511, -0.00664562, 0.0539325, 0.012129, -0.00595289, -0.0335781, -0.00209409, -0.00388862, 0.00978855, 0.016548, 0.0749642, -0.015503, -0.0358627, -0.0165102, 0.146539, 0.00421735, 0.0148656, -0.01755, 0.0172379, -0.015772, 0.0351191, -0.0175073, 0.000523782, 0.0145369, 0.0375461, 0.000509742, -0.00263082, 0.028631, 0.00498911, 0.00774373, 0.0401215, -0.0190868, -0.0144233, -0.0156577, 0.0110485, -0.0517973, -0.0508448, -0.0164912, -0.0122219, 0.0709729, -0.0369611, 0.0470247, 0.0124496, 0.00906071, 0.0226604, 0.018566, -0.0245455, 0.0367749, -0.0178264, -0.0328229, 0.0464369, 0.0531769, 0.00182667, 0.0297024, 0.058173, -0.0904324, -0.0391702, -0.04188, 0.0561676, 0.0142173, -0.00497234, 0.0812432, -0.0112911, 0.0152226, 0.0318516, -0.00715833, -0.0103754, -0.0272407, -0.0471265, 0.00571975, -0.0841156, 0.0764463, -0.0517103, 0.0482326, -0.0731175, 0.0300736, -0.0257948, -0.0574073, 0.0214971, 0.0526696, -0.0480085, -0.0453063, -0.0186158, 0.0145699, -0.00551919, -0.00953425, -0.0215894, 0.00438424, -0.0570062, -0.0453431, 0.0431766, 0.00753215, -0.0311071, -0.058833, -0.0474452, 0.0241969, 0.00832638, -0.00875147, 0.0563105, -0.0391594, 0.0483338, 0.0573794, -0.043172, -0.187128, -0.0181826, 0.00736702, -0.0279006, 0.0283556, -0.00339058, -0.0729951, -0.00369201, -0.0473034, -0.00633073, -0.0137167, 0.0227887, -0.00886818, 0.0156615, -0.00803763, -0.00245691, -0.00158528, -0.0531607, 0.0616175, -0.00451223, 0.00855797, -0.0170723, -0.0558952, 0.0377007, -0.0254558, 0.0228099, 0.0110774, -0.0247497, -0.0425175, -0.00622327, -0.0416173, -0.0434638, 0.0148605, -0.00860873, -0.0396952, -0.00924589, -0.0705948, 0.0133032, -0.0155201, 0.0569764, 0.0487667, 0.00873407, -0.0254264, 0.100562, 0.0830881, 0.0127119, -0.0201848, -0.036723, 0.012825, -0.024374, -0.0390287, -0.072757, 0.0102471, -0.07189, -0.0242941, -0.0311386, 0.00639011, -0.000257839, -0.0997975, -0.00546525, 0.0300712, -0.0476467, -0.0110089, -0.00366098, 0.0169501, 0.0102867, 0.096072, -0.00252323, 0.0235352, -0.0435554, 0.0283612, -0.0136788, 0.030676, -0.0217986, 0.033105, 0.0101302, 0.047408, 0.00393646, 0.0720768, 0.0186158, -0.0475858, -0.00172154, 0.015471, -0.0113226, -0.0181817, -0.0282765, -0.0944565, -0.0134216, -0.051192, 0.00196689, 0.0581154, -0.0169018, 0.00145915, -0.01306, 0.0498807, -0.028165, 0.0333043, 0.018756, -0.105832, -0.0345005, 0.00569908, 0.0393781, -0.02731, 0.0273811, -0.0427558, -0.0244884, -0.00499775, 0.230932, -0.0454051, -0.0359976, -0.0413764, 0.0303339, 0.00115982, 0.0112068, -0.00439295, -0.0121561, -0.0102862, -0.025722, -0.0209486, 0.0194363, 0.00795605, 0.0381209, 0.0469968, 0.0332632, 0.00367326, 0.0047097, 0.0542754, 0.00656743, 0.00478469, -0.0498174, -0.0579837, 0.0602247, -0.0627307, 0.017531, -0.00893831, 0.0012846, 0.0390013, -0.0242245, -0.0742106, -0.0298886, -0.226697, -0.0175261, -0.0262866, 0.0229692, -0.0737745, 0.00265714, 0.0191586, -0.0314733, -0.0141447, -0.0476009, -0.0730855, -0.0366746, 0.0362124, -0.0392424, -0.112806, 0.0130606, -0.0776176, 0.0653769, -0.0129618, -0.00553648, -0.0229774, 0.0223969, 0.012701, 0.0388993, 0.0663706, -0.0162927, 0.016243, -0.00131293, -0.00251651, 0.0558202, -0.0326401, 0.0317328, -0.0794463, 0.0406498, -0.0771381, -0.00479733, -0.00567547, 0.0988015, 0.0145452, 0.0308576, -0.0422524, 0.013251, -0.0444604, 0.0981828, 0.161388, -0.106962, -0.12283, 0.0102625, -0.0411401, -0.0651544, 0.0559984, -0.030696, 0.0507697, 0.443001, 0.0297937, -0.00282551, 0.00699462, -0.0330548, -0.0662166, 0.0494182, -0.0181392, -0.0188315, 0.0198731, 0.0850022, -0.0122921, -0.0305515, 0.0428607, 0.0802028, 0.0205668, 0.0113049, -0.0368367, 0.0401972, 0.0840094, 0.0438062, -0.0456826, -0.069008, 0.0145122, 0.0553373, -0.0148647, 0.0147235, -0.0186806, 0.0128752, -0.0053439, -0.0151172, -0.0349063, 0.0140178, 0.0646187, -0.0619314, -0.0266434, -0.00507387, 0.0234146, -0.02502, 0.0486796, 0.0149819, 0.00661905, -0.0319448};
        UNIT_ASSERT_EQUAL(userEmbedding.size(), reference.size());
        AssertFloatVectorsEqual(userEmbedding, reference);
    }

    Y_UNIT_TEST(MissingVectors) {
        auto badStats = userData;
        badStats.ClearVectors();

        UNIT_ASSERT_EXCEPTION_CONTAINS(userEmbeddingModel.Embed(badStats), yexception, "expected size");
    }
}
