#include "common.h"
#include "prepare_test_data.h"

#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/lookalike/lib/native/user_features_calculator.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/string/split.h>

using namespace NCrypta::NLookalike;

namespace {
    static const NLab::TUserData userData = PrepareTestUserData();
    static const TUserFeaturesCalculator userFeaturesCalculator(MakeFeaturesMapping());
}

Y_UNIT_TEST_SUITE(TUserFeaturesCalculator) {
    Y_UNIT_TEST(PrepareAffinitiveSitesIds) {
        TVector<TString> userAffinitiveSitesIds = StringSplitter(
                userFeaturesCalculator.PrepareAffinitiveSitesIds(userData)).Split(' ');
        TVector<TString> reference = StringSplitter("416215808 819522304 2033647617 1738640396 321154560").Split(' ');
        UNIT_ASSERT_EQUAL(userAffinitiveSitesIds.size(), reference.size());
        AssertAffinitiesEqual(userAffinitiveSitesIds, reference);
    }

    Y_UNIT_TEST(PrepareAffinitiveApps) {
        TVector<TString> userAffinitiveApps = StringSplitter(
                userFeaturesCalculator.PrepareAffinitiveApps(userData)).Split(' ');
        TVector<TString> reference = StringSplitter("10346255669534016644 1820054813962352258 13921572392949686720 1169464336012385531").Split(' ');
        UNIT_ASSERT_EQUAL(userAffinitiveApps.size(), reference.size());
        AssertAffinitiesEqual(userAffinitiveApps, reference);
    }

    Y_UNIT_TEST(PrepareFloatFeatures) {
        TVector<TString> userFloatFeatures = StringSplitter(
                userFeaturesCalculator.PrepareFloatFeatures(userData)).Split(',');
        TVector<TString> reference = StringSplitter("0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0,1,1,0,0,0,0.5,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0").Split(',');
        UNIT_ASSERT_EQUAL(userFloatFeatures.size(), reference.size());
        AssertStringFloatVectorsEqual(userFloatFeatures, reference);
    }
}
