#include "common.h"
#include "user_embedding_model.h"

#include <crypta/lib/proto/user_data/user_data.pb.h>

#include <util/generic/map.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

using namespace NCrypta::NLookalike;

TUserEmbeddingModel::TUserEmbeddingModel(const TString& modelFileName, const TString& featuresMappingFileName)
    : TEmbeddingModel(modelFileName)
    , UserFeaturesCalculator(GetFeaturesMapping(featuresMappingFileName)) {
}

TEmbedding TUserEmbeddingModel::Embed(const NLab::TUserData& user) const {
    static const TString outputLayerName = "query_embedding";
    const auto userDssmModel = DssmModel.GetSubmodel(outputLayerName);

    const auto userFloatFeatures = UserFeaturesCalculator.PrepareFloatFeatures(user);


    TMap<TString, std::function<TString(const NLab::TUserData&)>> headerToCalculatorMapping = {
        {"user_affinitive_sites_ids", &TUserFeaturesCalculator::PrepareAffinitiveSitesIds},
        {"user_affinitive_apps", &TUserFeaturesCalculator::PrepareAffinitiveApps}
    };

    TVector<TString> userAnnotations{"user_float_features"};
    TVector<TString> userFeatures{userFloatFeatures};
    for (const auto& it : headerToCalculatorMapping) {
        if (userDssmModel->HasVariable("$fields$" + it.first)) {
            userAnnotations.push_back(it.first);
            userFeatures.push_back(it.second(user));
        }
    }
    const auto userSample = MakeAtomicShared<NNeuralNetApplier::TSample>(userAnnotations, userFeatures);

    TEmbedding userEmbedding;
    userDssmModel->Apply(userSample, {outputLayerName}, userEmbedding);

    return userEmbedding;
}
