#pragma once

#include "common.h"
#include "embedding_model.h"
#include "user_features_calculator.h"

#include <crypta/lib/proto/user_data/user_data.pb.h>

#include <util/generic/string.h>

namespace NCrypta::NLookalike {
    class TUserEmbeddingModel : public TEmbeddingModel {
    public:
        TUserEmbeddingModel(const TString& modelFileName, const TString& featuresMappingFileName);

        TEmbedding Embed(const NLab::TUserData& user) const;

    private:
        TUserFeaturesCalculator UserFeaturesCalculator;
    };
}
