#pragma once

#include "common.h"

#include <crypta/lib/native/features_calculator/features_calculator.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>

#include <util/generic/string.h>

namespace NCrypta::NLookalike {
    class TUserFeaturesCalculator : public TFeaturesCalculator {
    public:
        TUserFeaturesCalculator(TFeaturesMapping featuresMapping);

        TString PrepareFloatFeatures(const NLab::TUserData& user) const;

        static TString PrepareAffinitiveSitesIds(const NLab::TUserData& user);

        static TString PrepareAffinitiveApps(const NLab::TUserData& user);
    };
}
