from util.generic.hash cimport THashMap
from util.generic.string cimport TString


cdef extern from 'crypta/lib/proto/user_data/user_data.pb.h' namespace 'NLab' nogil:
    cdef cppclass TUserData:
        bint ParseFromString(const TString& data)


cdef extern from 'crypta/lookalike/lib/native/user_features_calculator.h' namespace 'NCrypta::NLookalike' nogil:
    cdef cppclass TUserFeaturesCalculator:
        TUserFeaturesCalculator(const THashMap[TString, size_t]& featuresMapping) except +

        TString PrepareFloatFeatures(const TUserData& segment) except +
        TString PrepareAffinitiveSitesIds(const TUserData& segment) except +
        TString PrepareAffinitiveApps(const TUserData& segment) except +
