from yt.wrapper import ypath


def find_last_with_children(yt_client, path, required_children):
    subdirs = sorted([str(x) for x in yt_client.list(path, attributes=["type"]) if x.attributes["type"] == "map_node"], reverse=True)

    for subdir in subdirs:
        subdir_full_path = ypath.ypath_join(path, subdir)
        children = set(yt_client.list(subdir_full_path))
        if set(required_children).issubset(children):
            return subdir_full_path

    raise Exception("No matching directories found in {}".format(path))
