#!/usr/bin/env python
# -*- coding: utf-8 -*-

gender = 'gender'
age = 'age'
income = 'income'

group_id = 'GroupID'
yandexuid = 'yandexuid'

min_rank = 'min_rank'
max_rank = 'max_rank'
row_rank = 'row_rank'

stats = 'Stats'

feature = 'feature'
feature_index = 'feature_index'

segment_float_features = 'segment_float_features'
segment_affinitive_sites_ids = 'segment_affinitive_sites_ids'
segment_affinitive_apps = 'segment_affinitive_apps'

user_float_features = 'user_float_features'
user_affinitive_sites_ids = 'user_affinitive_sites_ids'
user_affinitive_apps = 'user_affinitive_apps'

segment_type = 'segment_type'

vector = 'vector'
distance = 'distance'
label = 'label'

precision = 'precision'
recall = 'recall'
pr_curve = 'pr_curve'
aupr = 'aupr'
aupr_relation = 'aupr_relation'


def _get_metrics_qnt_field_name(metric, qnt):
    return '{}_{}_qnt'.format(metric, qnt).replace('.', '')


def get_tp_qnt_field_name(qnt):
    return _get_metrics_qnt_field_name(metric='tp', qnt=qnt)


def get_fp_qnt_field_name(qnt):
    return _get_metrics_qnt_field_name(metric='fp', qnt=qnt)


def get_tn_qnt_field_name(qnt):
    return _get_metrics_qnt_field_name(metric='tn', qnt=qnt)


def get_fn_qnt_field_name(qnt):
    return _get_metrics_qnt_field_name(metric='fn', qnt=qnt)


# mobile fields
app_id = 'app_id'
id_type = 'id_type'
cryptaId = 'cryptaId'
app_type = 'app_type'
category = 'category'
device_id = 'id'
target_id = 'target_id'
game = 'game'
target_app = 'target_app'
devids_cnt = 'devids_cnt'
apps = 'apps'
MD5Hash = 'MD5Hash'
top_common_lal_apps = 'top_common_lal_apps'
top_common_lal_categories = 'top_common_lal_categories'
installs_by_ads_scores = 'installs_by_ads_scores'
promoted = 'promoted'
is_promoted = 'is_promoted'
price = 'price'

app_vector_features = 'app_vector_features'
app_features_from_stores = 'app_features_from_stores'
app_segment_features = 'app_segment_features'
app_publisher_vector = 'app_publisher_vector'
affinitive_apps = 'affinitive_apps'

user_apps_features_from_stores = 'user_apps_features_from_stores'
user_apps_vector_features = 'user_apps_vector_features'
user_web_features = 'user_web_features'
installed_apps = 'installed_apps'

user_vector = 'user_vector'
segment_vector = 'segment_vector'
app_vector = 'app_vector'

bundle_id = 'bundle_id'
centroids_bundle_ids = 'centroids_bundle_ids'
cluster_id = 'cluster_id'
old_cluster_id = 'old_cluster_id'
centroid_distance = 'centroid_distance'
old_cluster_distance = 'old_cluster_distance'

mean_vector = 'mean_vector'
centroid_id = 'centroid_id'
centroid_vector = 'centroid_vector'
centroid_rank = 'centroid_rank'
old_bundle_ids = 'old_centroids_bundle_ids'
old_centroids_ratio = 'old_centroids_ratio'

store_id = 'store_id'

# features export
goal_id = 'GoalID'
affinitive_sites = 'affinitive_sites'
affinitive_words = 'affinitive_words'
last_update_date = 'last_update_date'
