#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os

from crypta.lookalike.lib.python.utils.mobile_config.environment import environment
from crypta.lookalike.lib.python.utils.mobile_config import (
    production_config,
    testing_config,
)

is_production = environment == 'production'

MIN_APPS_COUNT = 50
MIN_DEVIDS_COUNT = 1000
VECTOR_SIZE = 512
DEVIDS_CNT_IDFA = 250
DEVIDS_CNT_GAID = 500
DAYS_TO_AGGREGATE_PROMOTED_APPS = 35
EMBEDDING_FEATURES_SIZE = 512
ADDITIONAL_USER_FEAURES_CNT = 6
MAX_ROWS_FOR_APP = 5e5
MIN_ROWS_FOR_APP = 1e3
MAX_PROMOTED_APPS_CNT = 1500
DAYS_TO_COUNT = 15
PROMOTED_APPS_RECOMMENDATIONS_METRICS = (
    'median_devids_cnt', 'pct_10_devids_cnt', 'pct_25_devids_cnt', 'pct_75_devids_cnt',
)

RELEASED = 'prestable' if is_production else 'testing'
RELEASED_APPLICATION = 'stable' if is_production else 'testing'
SANDBOX_RESOURCE_NAME = 'CRYPTA_MOBILE_LOOK_ALIKE_MODEL'
# STATFACE_PATH = 'Crypta/MobileLookalike'
APPS_FOR_TRAINING_COUNT = production_config.APPS_FOR_TRAINING_COUNT if is_production else testing_config.APPS_FOR_TRAINING_COUNT
CRYPTA_YT_WORKING_DIR = production_config.CRYPTA_YT_WORKING_DIR if is_production else testing_config.CRYPTA_YT_WORKING_DIR
MAX_TRAIN_ROWS = production_config.MAX_TRAIN_ROWS if is_production else testing_config.MAX_TRAIN_ROWS
USER_DATA_SAMPLING_RATE = production_config.USER_DATA_SAMPLING_RATE if is_production else testing_config.USER_DATA_SAMPLING_RATE
MAX_SEGMENT_SIZE = production_config.MAX_SEGMENT_SIZE if is_production else testing_config.MAX_SEGMENT_SIZE
USERS_TO_SAMPLE_CNT = production_config.USERS_TO_SAMPLE_CNT if is_production else testing_config.USERS_TO_SAMPLE_CNT
VALIDATION_APPS_CNT = production_config.VALIDATION_APPS_CNT if is_production else testing_config.VALIDATION_APPS_CNT

# common directories
COMMON_TMP_DIRECTORY = '//tmp'
COMMON_YQL_TMP_DIRECTORY = os.path.join(COMMON_TMP_DIRECTORY, 'yql')
LOOKALIKE_DIRECTORY = os.path.join(CRYPTA_YT_WORKING_DIR, 'lookalike')
MOBILE_LOOKALIKE_DIRECTORY = os.path.join(LOOKALIKE_DIRECTORY, 'mobile_lookalike')
LAB_DIRECTORY = os.path.join(CRYPTA_YT_WORKING_DIR, 'lab')
PROFILES_YT_DIRECTORY = os.path.join(CRYPTA_YT_WORKING_DIR, 'profiles')
PROFILES_INPUT_DATA = os.path.join(PROFILES_YT_DIRECTORY, 'input-data')
PROFILES_APP_METRICA = os.path.join(PROFILES_INPUT_DATA, 'app-metrica')
PROFILES_VECTORS_DIRECTORY = os.path.join(PROFILES_YT_DIRECTORY, 'export/vectors')

# siberia
SIBERIA_DIR = os.path.join(CRYPTA_YT_WORKING_DIR, 'siberia')
ALL_CRYPTAID_TABLE_FOR_DESCRIPTION = os.path.join(SIBERIA_DIR, 'custom/crypta_id_user_data/by_all_crypta_id')

# crypta external
MATCHING_DIRECTORY = '//home/crypta/public/matching/by_id'
IDFA_TO_CRYPTA_ID_MATCHING = os.path.join(MATCHING_DIRECTORY, 'idfa/crypta_id')
GAID_TO_CRYPTA_ID_MATCHING = os.path.join(MATCHING_DIRECTORY, 'gaid/crypta_id')
YUID_TO_CRYPTA_ID_MATCHING = os.path.join(MATCHING_DIRECTORY, 'yandexuid/crypta_id')
OAID_TO_CRYPTA_ID_MATCHING = os.path.join(MATCHING_DIRECTORY, 'oaid/crypta_id')
APP2VEC_TABLE = os.path.join(PROFILES_VECTORS_DIRECTORY, 'app2vec')
SITE2VEC_TABLE = os.path.join(PROFILES_VECTORS_DIRECTORY, 'site2vec')
DEVID_BY_APP_TABLE = os.path.join(PROFILES_APP_METRICA, 'devid_by_app')
APPS_BY_DEVID_DAILY = os.path.join(PROFILES_APP_METRICA, 'app_by_devid_daily')
APPS_BY_DEVID_MONTHLY = os.path.join(PROFILES_APP_METRICA, 'app_by_devid_monthly')
DEVIDS_APPS_WEIGHTS_TABLE = os.path.join(PROFILES_YT_DIRECTORY, 'internal-export/affinity/devids_apps_weights')
USER_DATA_BY_CRYPTA_ID = os.path.join(LAB_DIRECTORY, 'data/crypta_id/UserData')
USER_DATA_BY_ALL_CRYPTA_ID = os.path.join(LAB_DIRECTORY, 'data/all_crypta_id/UserData')
CATEGORICAL_FEATURES_MATCHING_DIR = os.path.join(PROFILES_INPUT_DATA, 'categorical_features')

# external
CAMPAIGNS_STATISTICS = '//home/bs/users/yabs-analytics/RMP/campaigns/latest'
EXTERNAL_RMP_DIRECTORY = '//home/rmp/production'
APP_TO_WEB_URLS = os.path.join(EXTERNAL_RMP_DIRECTORY, 'app_to_web_urls/latest/app_to_web_urls')
APP_DATA = os.path.join(EXTERNAL_RMP_DIRECTORY, 'app_data/latest/AppData')
MOBILE_POSTCLICK_LOG = '//logs/bs-mobile-postclick-log/1d'

# LaL training
LAL_TRAINING_DIRECTORY = os.path.join(MOBILE_LOOKALIKE_DIRECTORY, 'training')

# input
INPUT_DATA_DIRECTORY = os.path.join(LAL_TRAINING_DIRECTORY, 'input_data')
APPS_BY_DEVID_AND_CRYPTA_ID = os.path.join(INPUT_DATA_DIRECTORY, 'apps_by_devid_and_crypta_id')
DEVID_BY_APP_WITH_CRYPTA_ID = os.path.join(INPUT_DATA_DIRECTORY, 'devid_by_app_with_crypta_id')

# stores tables
STORES_DIRECTORY = os.path.join(LAL_TRAINING_DIRECTORY, 'stores')
MERGED_STORES_RAW = os.path.join(STORES_DIRECTORY, 'merged_stores_raw')
MERGED_STORES = os.path.join(STORES_DIRECTORY, 'merged_stores')
CATEGORICAL_FEATURES = os.path.join(STORES_DIRECTORY, 'categorical_features')
CATEGORY2VEC_TABLE = os.path.join(STORES_DIRECTORY, 'category2vector')

# apps
APPS_DIRECTORY = os.path.join(LAL_TRAINING_DIRECTORY, 'apps')
APPS_AFFINITIES = os.path.join(APPS_DIRECTORY, 'affinitive_apps')
VALIDATION_APPS_TABLE = os.path.join(APPS_DIRECTORY, 'apps_for_validation')
TRAIN_APPS_TABLE = os.path.join(APPS_DIRECTORY, 'apps_for_training')
# TOP_COMMON_APPS = os.path.join(APPS_DIRECTORY, 'top_common_apps')
# PROMOTED_APPS = os.path.join(APPS_DIRECTORY, 'promoted_apps')
TRAIN_DEVIDS_COUNTS_BY_APP = os.path.join(APPS_DIRECTORY, 'train_counts')

# mobile features
USERS_TRAIN_FEATURES_MOBILE = os.path.join(LAL_TRAINING_DIRECTORY, 'users_train_features_mobile')
USERS_VALIDATION_FEATURES_MOBILE = os.path.join(LAL_TRAINING_DIRECTORY, 'users_validation_features_mobile')
APPS_FEATURES_FROM_STORES = os.path.join(LAL_TRAINING_DIRECTORY, 'apps_features_from_stores')

# web features
LAL_FEATURES_MAPPING_TABLE = os.path.join(LAL_TRAINING_DIRECTORY, 'features_mapping')
USERS_DSSM_FEATURES_WEB = os.path.join(LAL_TRAINING_DIRECTORY, 'users_dssm_web_features')
USER_DATA_STATS_FOR_APPS = os.path.join(LAL_TRAINING_DIRECTORY, 'user_data_stats_for_apps')
USER_DATA_STATS_FOR_CATEGORIES = os.path.join(LAL_TRAINING_DIRECTORY, 'user_data_stats_for_categories')
DEFAULT_USER_DSSM_FEATURES_WEB = os.path.join(LAL_TRAINING_DIRECTORY, 'default_user_dssm_web_features')
APP_SEGMENTS_DSSM_WEB_FEATURES_TABLE = os.path.join(LAL_TRAINING_DIRECTORY, 'app_segments_dssm_web_features')
CATEGORY_SEGMENTS_DSSM_WEB_FEATURES_TABLE = os.path.join(LAL_TRAINING_DIRECTORY, 'category_segments_dssm_web_features')

APPS_VECTORS_BY_PUBLISHER = os.path.join(LAL_TRAINING_DIRECTORY, 'app_vector_by_publisher_url')
CATEGORY_VECTORS_BY_PUBLISHER = os.path.join(LAL_TRAINING_DIRECTORY, 'category_vector_by_publisher_url')

APP_DSSM_FEATURES = os.path.join(LAL_TRAINING_DIRECTORY, 'app_dssm_features')
APP_DSSM_VECTORS = os.path.join(LAL_TRAINING_DIRECTORY, 'app_dssm_vectors')
TRAIN_SAMPLE = os.path.join(LAL_TRAINING_DIRECTORY, 'train_sample')

# validation
VALIDATION_DIRECTORY = os.path.join(LAL_TRAINING_DIRECTORY, 'validation')
USERS_DSSM_VECTORS = os.path.join(VALIDATION_DIRECTORY, 'users_dssm_vectors')
USERS_DSSM_FEATURES = os.path.join(VALIDATION_DIRECTORY, 'users_dssm_features')
VALIDATION_APPS_DSSM_VECTORS = os.path.join(VALIDATION_DIRECTORY, 'validation_apps_dssm_vectors')
VALIDATION_DSSM_LAL_DISTANCES = os.path.join(VALIDATION_DIRECTORY, 'validation_dssm_lal_distances')
VALIDATION_DSSM_SEGMENTS_POINTS = os.path.join(VALIDATION_DIRECTORY, 'validation_dssm_segments_points')
VALIDATION_RANDOM_SEGMENTS_POINTS = os.path.join(VALIDATION_DIRECTORY, 'validation_random_segments_points')
VALIDATION_DSSM_PR_STATS = os.path.join(VALIDATION_DIRECTORY, 'validation_dssm_pr_stats')
VALIDATION_RANDOM_PR_STATS = os.path.join(VALIDATION_DIRECTORY, 'validation_random_pr_stats')

# metrics
METRICS_DIRECTORY = os.path.join(VALIDATION_DIRECTORY, 'metrics')
METRICS_BY_APP_TYPE = os.path.join(METRICS_DIRECTORY, 'metrics_by_app_type')
METRICS_BY_APP_SOURCE = os.path.join(METRICS_DIRECTORY, 'metrics_by_app_source')
METRICS_BY_DEVICE_TYPE = os.path.join(METRICS_DIRECTORY, 'metrics_by_device_type')

# datalens
DATALENS_MOBILE_LAL_DIRECTORY = os.path.join(LAL_TRAINING_DIRECTORY, 'datalens')
DATALENS_MOBILE_LAL_METRICS_TABLE = os.path.join(DATALENS_MOBILE_LAL_DIRECTORY, 'mobile_lal_metrics_by_day')
DATALENS_MOBILE_LAL_COUNTERS_TABLE = os.path.join(DATALENS_MOBILE_LAL_DIRECTORY, 'counters')
DATALENS_MOBILE_LAL_QUALITY_TABLE = os.path.join(DATALENS_MOBILE_LAL_DIRECTORY, 'quality')
DATALENS_MOBILE_LAL_PROMOTED_APPS_TABLE = os.path.join(DATALENS_MOBILE_LAL_DIRECTORY, 'promoted_apps')
DATALENS_MOBILE_LAL_RECOMMENDATIONS_TABLE = os.path.join(DATALENS_MOBILE_LAL_DIRECTORY, 'recommendations')
DATALENS_MOBILE_LAL_USERS_FEATURES_TABLE = os.path.join(DATALENS_MOBILE_LAL_DIRECTORY, 'users_features')

# LaL application
TOP_COMMON_LAL_APPS_DIRECTORY = os.path.join(MOBILE_LOOKALIKE_DIRECTORY, 'top_common_lal_apps')
GAME_APPS_CNT = 8
NON_GAME_APPS_CNT = 12
TOP_COMMON_LAL_APPS_KEYWORD = 1053
PROMOTED_APPS_KEYWORD = 1063
TOP_COMMON_LAL_CATEGORIES_KEYWORD = 1122
CRYPTA_RMP_FEATURES_KEYWORD = 1138
DAYS_TO_KEEP_RECOMMENDATIONS = 14
DAYS_TO_KEEP_APPS_VECTORS = 35
RECOMMENDED_PROMOTED_APPS_CNT = 50
MIN_DEVIDS_COUNT_PROMOTED = 0
DAYS_TO_AGGREGATE_PROMOTED_APPS_FEATURES = 3
TOP_COMMON_CATEGORIES_CNT = 10
MONTHS_FOR_INSTALLERS_BY_AD = 1
PERIOD_TO_CALCULATE_INSTALLERS_BY_AD = 3
APPS_AFFINITIES_COUNT = 20
SEGMENTS_AFFINITIES_COUNT = 10

# new application
INSTALLERS_BY_AD_DIR = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'installers_by_ad')
# INSTALLERS_BY_AD_SEGMENTS = os.path.join(INSTALLERS_BY_AD_DIR, 'installers_by_ad_segments')
INSTALLERS_BY_AD_FEATURES = os.path.join(INSTALLERS_BY_AD_DIR, 'installers_by_ad_features')
INSTALLERS_BY_AD_VECTORS = os.path.join(INSTALLERS_BY_AD_DIR, 'installers_by_ad_vectors')
INSTALLERS_BY_AD_LAL_DISTANCES = os.path.join(INSTALLERS_BY_AD_DIR, 'installers_by_ad_distances')

APPS_DIRECTORY_APPLICATION = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'apps')
APPS_SEGMENTS = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'apps_segments')
APPS_FEATURES = os.path.join(APPS_DIRECTORY_APPLICATION, 'apps_features')
APPS_VECTORS = os.path.join(APPS_DIRECTORY_APPLICATION, 'apps_vectors')
PROMOTED_APPS_LAL_DISTANCES = os.path.join(APPS_DIRECTORY_APPLICATION, 'promoted_apps_distances')
TOP_APPS_LAL_DISTANCES = os.path.join(APPS_DIRECTORY_APPLICATION, 'top_apps_distances')

USERS_DIRECTORY_APPLICATION = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'users')
USERS_FEATURES = os.path.join(USERS_DIRECTORY_APPLICATION, 'users_features')
USERS_VECTORS = os.path.join(USERS_DIRECTORY_APPLICATION, 'users_vectors')

CLUSTERING_TABLE = os.path.join(SIBERIA_DIR, 'custom_audience/apps_clustering/apps')
CATEGORIES_DIRECTORY_APPLICATION = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'categories')
CATEGORIES_VECTORS = os.path.join(CATEGORIES_DIRECTORY_APPLICATION, 'categories_vectors')
CATEGORIES_LAL_DISTANCES = os.path.join(CATEGORIES_DIRECTORY_APPLICATION, 'categories_distances')

CRYPTA_ID_TO_ID_TYPE = os.path.join(USERS_DIRECTORY_APPLICATION, 'crypta_id_to_id_type')

# apps
TOP_COMMON_APPS = os.path.join(APPS_DIRECTORY_APPLICATION, 'top_common_apps')
PROMOTED_APPS = os.path.join(APPS_DIRECTORY_APPLICATION, 'promoted_apps')
INSTALLERS_BY_AD_SEGMENTS = os.path.join(APPS_DIRECTORY_APPLICATION, 'installers_by_ad_segments')
PROMOTED_APPS_WEB_FEATURES = os.path.join(APPS_DIRECTORY_APPLICATION, 'promoted_apps_web_features')
SEGMENTS_INSTALLERS_BY_AD_WEB_FEATURES = os.path.join(APPS_DIRECTORY_APPLICATION, 'installers_by_ad_web_features')
PROMOTED_APPS_DSSM_FEATURES = os.path.join(APPS_DIRECTORY_APPLICATION, 'promoted_apps_dssm_features')
SEGMENTS_INSTALLERS_BY_AD_DSSM_FEATURES = os.path.join(APPS_DIRECTORY_APPLICATION, 'installers_by_ad_dssm_features')
APPS_DSSM_FEATURES_APPLICATION = os.path.join(APPS_DIRECTORY_APPLICATION, 'apps_dssm_features')
APPS_DSSM_VECTORS_APPLICATION = os.path.join(APPS_DIRECTORY_APPLICATION, 'dssm_vectors')
SEGMENTS_DSSM_VECTORS_APPLICATION = os.path.join(APPS_DIRECTORY_APPLICATION, 'segments_dssm_vectors')
PROMOTED_APPS_VECTORS_LOG_DIRECTORY = os.path.join(APPS_DIRECTORY_APPLICATION, 'promoted_apps_vectors_log')
MERGED_STORES_SAVED = os.path.join(APPS_DIRECTORY_APPLICATION, 'merged_stores')
APP_DSSM_FEATURES_SAVED = os.path.join(APPS_DIRECTORY_APPLICATION, 'apps_dssm_features_from_training')
APPS_FEATURES_FROM_STORES_SAVED = os.path.join(APPS_DIRECTORY_APPLICATION, 'apps_features_from_stores')
CATEGORY_SEGMENTS_DSSM_WEB_FEATURES_TABLE_SAVED = os.path.join(APPS_DIRECTORY_APPLICATION, 'category_segments_dssm_web_features')
CATEGORY2VEC_TABLE_SAVED = os.path.join(APPS_DIRECTORY_APPLICATION, 'category2vector')
APPS_VECTORS_BY_PUBLISHER_SAVED = os.path.join(APPS_DIRECTORY_APPLICATION, 'app_vector_by_publisher_url')
CATEGORY_VECTORS_BY_PUBLISHER_SAVED = os.path.join(APPS_DIRECTORY_APPLICATION, 'category_vector_by_publisher_url')
SEGMENTS_AFFINITIES = os.path.join(APPS_DIRECTORY_APPLICATION, 'affinitive_apps_for_segments')

# users
USERS_MOBILE_FEATURES_APPLICATION = os.path.join(USERS_DIRECTORY_APPLICATION, 'mobile_features')
USERS_WEB_FEATURES_APPLICATION = os.path.join(USERS_DIRECTORY_APPLICATION, 'web_features')
USERS_DSSM_VECTORS_APPLICATION = os.path.join(USERS_DIRECTORY_APPLICATION, 'dssm_vectors')
DEFAULT_USER_DSSM_FEATURES_WEB_SAVED = os.path.join(USERS_DIRECTORY_APPLICATION, 'default_user_dssm_web_features')

# input data
INPUT_DATA_DIRECTORY_APPLICATION = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'input_data')
APPS_BY_DEVID_AND_CRYPTA_ID_DAILY = os.path.join(INPUT_DATA_DIRECTORY_APPLICATION, 'apps_by_devid_and_crypta_id')
DEVID_BY_APP_WITH_CRYPTA_ID_DAILY = os.path.join(INPUT_DATA_DIRECTORY_APPLICATION, 'devid_by_app_with_crypta_id')

LAL_DISTANCES_TOP_APPS = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'lal_distances_top_apps')
LAL_DISTANCES_PROMOTED_APPS = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'lal_distances_promoted_apps')
LAL_DISTANCES_CATEGORIES = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'lal_distances_categories')
LAL_DISTANCES_INSTALLERS_BY_AD_SEGMENTS = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'lal_distances_installers_by_ad')

# recommendations
RECOMMENDATIONS_DIRECTORY = os.path.join(TOP_COMMON_LAL_APPS_DIRECTORY, 'recommendations')
DEVIDS_CNT_FOR_APPS = os.path.join(RECOMMENDATIONS_DIRECTORY, 'devids_cnt')
RECOMMENDATIONS_TABLE = os.path.join(RECOMMENDATIONS_DIRECTORY, 'apps_recommendations')
NEW_RECOMMENDATIONS_TABLE = os.path.join(RECOMMENDATIONS_DIRECTORY, 'new_apps_recommendations')
OUTPUT_DIRECTORY = os.path.join(RECOMMENDATIONS_DIRECTORY, 'output')
PROMOTED_APPS_RECOMMENDATION_COUNTS = os.path.join(RECOMMENDATIONS_DIRECTORY, 'promoted_apps_recommendations_counts')
INSTALLS_BY_AD_SCORES = os.path.join(RECOMMENDATIONS_DIRECTORY, 'installs_by_ad_scores')
NEW_INSTALLS_BY_AD_SCORES = os.path.join(RECOMMENDATIONS_DIRECTORY, 'new_installs_by_ad_scores')

# clustering
MOBILE_LAL_CLUSTERS = os.path.join(MOBILE_LOOKALIKE_DIRECTORY, 'clusters')
CLUSTER_CENTROIDS_VECTORS = os.path.join(MOBILE_LAL_CLUSTERS, 'cluster_centroids_vectors')

RMP_DIRECTORY = os.path.join(CRYPTA_YT_WORKING_DIR, 'rmp')
CLUSTERS_INFO = os.path.join(RMP_DIRECTORY, 'cluster_centroids')
APPS_CLUSTERING = os.path.join(RMP_DIRECTORY, 'apps_clustering')

CENTROIDS_TO_KEEP = 10

NEW_RECOMMENDATIONS_TABLE_IDX = 0
NEW_SEGMENT_SCORES_TABLE_IDX = 1

# model
MODEL_VERSIONS_TO_KEEP = 3

MOBILE_LOOKALIKE_VERSIONS_DIRECTORY = os.path.join(MOBILE_LOOKALIKE_DIRECTORY, 'versions')
MODEL_DATA_DIRECTORY = os.path.join(LAL_TRAINING_DIRECTORY, 'model')
MODEL_APPLIER_FILE = 'dssm_model.applier'
SEGMENTS_FEATURES_DICT_FILE = 'segments_dict.json'
APPS_FEATURES_DICT_FILE = 'apps_features_dict.json'
