from util.generic.hash cimport THashMap
from util.generic.ptr cimport MakeHolder
from util.generic.string cimport TString

from crypta.lookalike.lib.native.segment_features_calculator cimport (
    TSegmentFeaturesCalculator as TSegmentFeaturesCalculatorImpl,
    TUserDataStats as TUserDataStatsImpl,
)


cdef class TSegmentFeaturesCalculator:
    def __init__(self, THashMap[TString, size_t] features_mapping):
        self._impl = MakeHolder[TSegmentFeaturesCalculatorImpl](features_mapping)

    def PrepareFloatFeatures(self, user_data_stats):
        cdef TUserDataStatsImpl user_data_stats_impl
        user_data_stats_impl.ParseFromString(user_data_stats.SerializeToString())
        return self._impl.Get().PrepareFloatFeatures(user_data_stats_impl)

    def PrepareAffinitiveSitesIds(self, user_data_stats):
        cdef TUserDataStatsImpl user_data_stats_impl
        user_data_stats_impl.ParseFromString(user_data_stats.SerializeToString())
        return self._impl.Get().PrepareAffinitiveSitesIds(user_data_stats_impl)

    def PrepareAffinitiveApps(self, user_data_stats):
        cdef TUserDataStatsImpl user_data_stats_impl
        user_data_stats_impl.ParseFromString(user_data_stats.SerializeToString())
        return self._impl.Get().PrepareAffinitiveApps(user_data_stats_impl)
