from yt.yson import get_bytes

from crypta.lib.proto.user_data import enums_pb2
from crypta.lib.proto.user_data import user_data_stats_pb2
from crypta.lookalike.lib.python.utils import segment_features_calculator
from crypta.lookalike.lib.python.utils.config import config
from crypta.lookalike.lib.python.utils.test import common


def add_gender(user_data_stats, segment, count):
    gender = user_data_stats.Attributes.Gender.add()
    gender.Gender = segment
    gender.Count = count


def add_age(user_data_stats, segment, count):
    age = user_data_stats.Attributes.Age.add()
    age.Age = segment
    age.Count = count


def add_income(user_data_stats, segment, count):
    income = user_data_stats.Attributes.Income.add()
    income.Income = segment
    income.Count = count


def add_region(user_data_stats, region_id, count):
    region = user_data_stats.Attributes.Region.add()
    region.Region = region_id
    region.Count = count


def prepare_user_data_stats():
    user_data_stats = user_data_stats_pb2.TUserDataStats()

    for i in range(config.EMBEDDING_FEATURES_SIZE):
        user_data_stats.Distributions.Main.Mean.Data.append(1)

    user_data_stats.Counts.Total = common.TEST_COUNTS_TOTAL

    add_gender(user_data_stats=user_data_stats, segment=enums_pb2.TGender.UNKNOWN_GENDER, count=15)
    add_gender(user_data_stats=user_data_stats, segment=enums_pb2.TGender.MALE, count=1915)
    add_gender(user_data_stats=user_data_stats, segment=enums_pb2.TGender.FEMALE, count=1042)
    assert user_data_stats.Counts.Total == sum(gender.Count for gender in user_data_stats.Attributes.Gender)

    add_age(user_data_stats=user_data_stats, segment=enums_pb2.TAge.UNKNOWN_AGE, count=9)
    add_age(user_data_stats=user_data_stats, segment=enums_pb2.TAge.FROM_0_TO_17, count=34)
    add_age(user_data_stats=user_data_stats, segment=enums_pb2.TAge.FROM_18_TO_24, count=94)
    add_age(user_data_stats=user_data_stats, segment=enums_pb2.TAge.FROM_25_TO_34, count=640)
    add_age(user_data_stats=user_data_stats, segment=enums_pb2.TAge.FROM_35_TO_44, count=1199)
    add_age(user_data_stats=user_data_stats, segment=enums_pb2.TAge.FROM_45_TO_54, count=659)
    add_age(user_data_stats=user_data_stats, segment=enums_pb2.TAge.FROM_55_TO_99, count=337)
    assert user_data_stats.Counts.Total == sum(age.Count for age in user_data_stats.Attributes.Age)

    add_income(user_data_stats=user_data_stats, segment=enums_pb2.TIncome.UNKNOWN_INCOME, count=1)
    add_income(user_data_stats=user_data_stats, segment=enums_pb2.TIncome.INCOME_A, count=16)
    add_income(user_data_stats=user_data_stats, segment=enums_pb2.TIncome.INCOME_B1, count=85)
    add_income(user_data_stats=user_data_stats, segment=enums_pb2.TIncome.INCOME_B2, count=739)
    add_income(user_data_stats=user_data_stats, segment=enums_pb2.TIncome.INCOME_C1, count=1741)
    add_income(user_data_stats=user_data_stats, segment=enums_pb2.TIncome.INCOME_C2, count=390)
    assert user_data_stats.Counts.Total == sum(income.Count for income in user_data_stats.Attributes.Income)

    add_region(user_data_stats=user_data_stats, region_id=213, count=1486)
    add_region(user_data_stats=user_data_stats, region_id=2, count=1486)
    assert user_data_stats.Counts.Total == sum(region.Count for region in user_data_stats.Attributes.Region)

    segments = (
        '216_9,216_10,216_11,216_36,216_37,216_482,216_516,216_519,216_520,216_522,216_523,216_529,216_530,216_531,'
        '216_532,216_533,216_534,216_535,216_537,216_541,216_542,216_544,216_546,216_547,216_548,216_549,216_550,'
        '216_551,216_552,216_553,216_555,216_556,216_557,216_558,216_559,216_560,216_561,216_562,216_563,216_584,'
        '216_585,216_587,216_591,216_593,216_594,216_595,216_596,216_597,216_600,216_601,216_603,216_605,216_606,'
        '216_609,216_610,216_611,216_613,216_614,216_615,216_616,216_620,216_621,216_622,216_623,216_624,216_625,'
        '216_626,216_627,216_628,216_629,216_630,216_634,216_635,216_636,216_637,216_639,216_640,216_641,216_647,'
        '216_648,216_657,216_658,216_659,216_661,216_662,216_663,216_664,216_665,216_666,216_668,216_669,216_670,'
        '216_671,216_672,216_675,216_676,216_679,216_680,216_681,216_682,216_684,216_685,216_686,216_687,216_689,'
        '216_690,216_691,216_709,216_710,216_711,216_713,216_714,216_715,216_716,216_717,216_718,216_719,216_720,'
        '216_721,216_722,216_723,216_724,216_726,216_727,216_728,216_729,216_731,216_732,216_733,216_734,216_735,'
        '216_737,216_738,216_739,216_741,216_743,216_744,217_12,217_13,217_14,217_15,217_16,217_17,217_18,217_19,'
        '217_22,217_23,217_44,217_56,217_57,217_68,217_69,217_70,217_71,217_88,217_89,217_90,217_95,217_101,217_102,'
        '217_105,217_106,217_109,217_117,217_118,217_134,217_135,217_139,217_141,217_142,217_144,217_146,217_147,'
        '217_148,217_161,217_166,217_167,217_171,217_199,217_211,217_222,217_223,217_224,217_225,217_226,217_227,'
        '217_242,217_243,217_244,217_247,217_251,217_256,217_257,217_260,217_264,217_265,217_266,217_267,217_268,'
        '217_269,217_272,217_288,217_292,217_303,217_306,217_331,217_382,217_383,217_384,217_385,217_386,217_387,'
        '217_388,217_389,217_390,217_391,217_392,217_393,217_394,217_395,217_405,217_407,217_424,217_425,217_433,'
        '217_434,217_435,217_436,217_437,217_439,217_441,217_467,217_473,217_507,217_508,217_514,217_515,217_524,'
        '217_536,217_564,217_565,217_566,217_567,217_569,217_570,217_571,217_572,217_573,217_574,217_575,217_576,'
        '217_577,217_578,217_580,217_581,217_582,217_583,217_612,217_688,546_1119,546_1121,546_1141,546_1142,546_1143,'
        '546_1144,546_1145,546_1146,546_1147,546_1148,546_1155,546_1208,546_1218,546_1222,546_1223,546_1251,546_1252,'
        '546_1275,546_1299,546_1300,546_1301,546_1302,546_1303,546_1304,546_1305,546_1312,546_1373,546_1374,546_1375,'
        '546_1377,546_1379,546_1393,546_1403,546_1407,546_1408,546_1409,547_1023,547_1024,547_1025,547_1026,547_1027,'
        '547_1028,547_1029,547_1030,547_1031,547_1032,547_1033,547_1034,547_1035,547_1036,547_1037,547_1038,547_1039,'
        '547_1040,547_1041,547_1042,547_1043,547_1044,547_1045,547_1046,547_1047,547_1048,547_1049,547_1050,547_1051,'
        '547_1052,547_1053,547_1054,547_1055,547_1056,547_1058,547_1059,547_1060,547_1061,547_1062,547_1063,547_1064,'
        '547_1065,547_1066,547_1067,547_1068,547_1069,547_1070,547_1071,547_1072,547_1073,547_1074,547_1075,547_1077,'
        '547_1078,547_1079,547_1080,547_1081,547_1082,547_1083,547_1084,547_1085,547_1086,547_1087,547_1088,547_1089,'
        '547_1090,547_1091,547_1092,547_1093,547_1094,547_1095,547_1096,547_1097,547_1098,547_1099,547_1100,547_1101,'
        '547_1102,547_1103,547_1104,547_1105,547_1106,547_1107,547_1108,547_1109,547_1110,547_1111,547_1112,547_1113,'
        '547_1114,547_1115,547_1116,547_1117,547_1118,547_1122,547_1123,547_1124,547_1125,547_1126,547_1127,547_1128,'
        '547_1129,547_1130,547_1131,547_1132,547_1133,547_1134,547_1135,547_1136,547_1137,547_1138,547_1139,547_1140,'
        '547_1162,547_1163,547_1164,547_1166,547_1167,547_1168,547_1169,547_1170,547_1171,547_1172,547_1173,547_1174,'
        '547_1192,547_1193,547_1196,547_1197,547_1202,547_1204,547_1248,547_1263,547_1264,547_1265,547_1290,547_1291,'
        '547_1292,547_1293,547_1296,547_1321,547_1340,547_1341,547_1342,547_1343,547_1344,547_1345,547_1346,547_1347,'
        '547_1348,547_1349,547_1350,547_1351,547_1623,547_1624,547_1629,547_1632,547_1633,547_1634,547_1635,547_1636,'
        '547_1637,547_1638,547_1639,547_1640,549_1120,549_1149,549_1150,549_1151,549_1152,549_1156,549_1157,549_1158,'
        '549_1159,549_1160,549_1161,549_1177,549_1194,549_1195,549_1199,549_1200,549_1201,549_1206,549_1207,549_1209,'
        '549_1213,549_1214,549_1215,549_1216,549_1217,549_1219,549_1220,549_1224,549_1225,549_1226,549_1227,549_1228,'
        '549_1230,549_1231,549_1232,549_1233,549_1235,549_1236,549_1238,549_1240,549_1241,549_1246,549_1249,549_1250,'
        '549_1253,549_1254,549_1255,549_1257,549_1258,549_1259,549_1260,549_1261,549_1262,549_1266,549_1267,549_1268,'
        '549_1269,549_1270,549_1271,549_1272,549_1273,549_1274,549_1276,549_1277,549_1278,549_1279,549_1280,549_1281,'
        '549_1282,549_1283,549_1284,549_1286,549_1287,549_1288,549_1294,549_1295,549_1297,549_1298,549_1306,549_1307,'
        '549_1310,549_1311,549_1315,549_1317,549_1319,549_1320,549_1322,549_1323,549_1324,549_1325,549_1329,549_1331,'
        '549_1332,549_1333,549_1335,549_1337,549_1338,549_1339,549_1353,549_1354,549_1355,549_1356,549_1357,549_1358,'
        '549_1359,549_1360,549_1361,549_1362,549_1363,549_1364,549_1365,549_1366,549_1367,549_1368,549_1369,549_1370,'
        '549_1371,549_1376,549_1378,549_1380,549_1381,549_1384,549_1387,549_1390,549_1392,549_1396,549_1398,549_1399,'
        '549_1400,549_1401,549_1402,549_1614,549_1615,549_1616,549_1617,549_1622,549_1625,549_1631,549_1641,549_1643,'
        '549_1645,549_1646,549_1647,549_1648,549_1649,549_1650,549_1651,549_1654,549_1656,549_1657,549_1658,549_1659,'
        '601_1,601_2,601_3,601_4,601_5,601_6,601_7,601_8,601_9,601_10,601_11,601_12,601_13,601_14,601_15,601_16,601_17,'
        '601_18,601_19,601_20,601_21,601_22,601_23,601_24,601_25,601_26,601_27,601_28,601_29,601_30,601_31,601_32,'
        '601_33,601_34,601_35,601_36,601_37,601_38,601_39,601_40,601_41,601_42,601_43,601_44,601_45,601_46,601_47,'
        '601_48,601_49,601_50,601_51,601_52,601_53,601_54,601_55,601_56,601_57,601_58,601_60,601_61,601_62,601_63,'
        '601_64,601_65,601_66,601_67,601_68,601_69,601_70,601_71,601_72,601_74,601_75,601_76,601_77,601_78,601_79,'
        '601_80,601_81,601_82,601_83,601_84,601_85,601_86,601_87,601_88,601_89,601_91,601_92,601_93,601_94,601_95,'
        '601_96,601_97,601_99,601_100,601_101,601_102,601_103,601_104,601_105,601_106,601_107,601_108,601_109,601_110,'
        '601_111,601_112,601_113,601_114,601_115,601_116,601_118,601_119,601_120,601_121,601_122,601_124,601_125,'
        '601_126,601_127,601_128,601_129,601_130,601_131,601_132,601_133,601_134,601_136,601_137,601_138,601_140,'
        '601_141,601_142,601_144,601_145,601_146,601_147,601_148,601_149,601_150,601_151,601_152,601_153,601_154,'
        '601_155,601_156,601_157,601_158,601_159,601_160,601_161,601_162,601_163,601_164,601_165,601_166,601_167,'
        '601_168,601_169,601_170,601_171,601_172,601_173,601_174,601_175,601_176,601_177,601_178,601_179,601_180,'
        '601_181,601_182,601_183,601_184,601_185,601_186,601_187,601_188,601_189,601_190,601_191,601_192,601_193,'
        '601_194,601_195,601_196,601_197,601_198,601_199,601_200,601_201,601_202,601_203,601_204,601_205,601_206,'
        '601_207,601_208,601_209,601_210,601_211,601_212,601_213,601_214,601_215,601_216,601_217,601_218,601_219,'
        '601_220,601_221,601_222,601_223,601_224,601_225,601_226,601_227,601_228,601_229,601_230,601_231,601_232,'
        '601_233,601_234,601_235,601_236,601_237,601_238,601_239,601_240,601_241,601_242,601_243,601_244,601_245,'
        '601_246,601_247,601_248,601_249,601_250,601_251,601_252,601_254,601_255,601_256,601_257,601_258,601_259,'
        '601_260,601_261,601_262,601_263,601_264,601_265,601_267,601_268,601_269,601_270,601_271,601_276,601_277,'
        '601_287,601_288,601_289,601_292,601_293,601_294,601_295,601_296,601_297,601_298,601_299,601_300,601_301,'
        '601_302,601_303,601_304,601_305,601_306,601_307,601_308,601_309,601_310,601_311,601_313,601_314,601_316,'
        '601_317,601_318,601_319,602_1,602_2,602_3,602_4,602_5,602_6,602_7,602_8,602_9,602_10,602_11,602_12,602_13,'
        '602_14,602_15,602_16,602_17,602_18,602_19,602_20,602_21,602_22,602_23,602_24,602_25,602_26,602_27,602_28,'
        '602_29,602_30,602_31,602_32,602_33,602_34,602_35,602_36,602_37,602_38,602_39,602_40,602_41,602_42,602_43,'
        '602_44,602_46,602_47,602_48,602_49,602_50,602_51,602_52,602_54,602_55,602_56,602_57,602_58,602_60,602_61,'
        '602_62,602_63,602_64,602_65,602_66,602_67,602_68,602_69,602_70,602_71,602_72,602_74,602_75,602_76,602_77,'
        '602_78,602_79,602_80,602_81,602_82,602_83,602_84,602_85,602_86,602_87,602_88,602_89,602_91,602_92,602_93,'
        '602_94,602_95,602_96,602_97,602_99,602_100,602_101,602_102,602_103,602_104,602_105,602_106,602_107,602_108,'
        '602_109,602_110,602_111,602_112,602_113,602_114,602_115,602_116,602_117,602_118,602_119,602_120,602_121,'
        '602_122,602_124,602_125,602_126,602_127,602_128,602_129,602_130,602_132,602_133,602_134,602_135,602_136,'
        '602_137,602_138,602_140,602_141,602_142,602_144,602_145,602_146,602_147,602_148,602_149,602_150,602_151,'
        '602_152,602_153,602_154,602_155,602_157,602_158,602_159,602_160,602_161,602_162,602_163,602_164,602_165,'
        '602_166,602_167,602_168,602_169,602_170,602_171,602_172,602_173,602_174,602_175,602_176,602_177,602_178,'
        '602_179,602_181,602_182,602_183,602_184,602_185,602_186,602_187,602_188,602_189,602_190,602_191,602_192,'
        '602_193,602_194,602_195,602_196,602_197,602_198,602_199,602_200,602_201,602_202,602_203,602_204,602_205,'
        '602_206,602_207,602_208,602_209,602_210,602_211,602_212,602_213,602_214,602_215,602_216,602_217,602_218,'
        '602_219,602_220,602_221,602_222,602_223,602_224,602_225,602_226,602_227,602_228,602_229,602_230,602_231,'
        '602_232,602_233,602_234,602_236,602_237,602_238,602_239,602_240,602_241,602_242,602_243,602_244,602_245,'
        '602_246,602_247,602_248,602_249,602_250,602_251,602_252,602_254,602_255,602_256,602_257,602_258,602_259,'
        '602_260,602_261,602_262,602_263,602_264,602_265,602_267,602_268,602_269,602_270,602_271,602_272,602_273,'
        '602_277,602_287,602_288,602_289,602_290,602_292,602_293,602_294,602_295,602_296,602_297,602_298,602_299,'
        '602_300,602_301,602_302,602_303,602_304,602_305,602_306,602_307,602_308,602_309,602_310,602_311,602_313,'
        '602_314,602_316,602_317,602_318,602_319'
    )
    for keyword, id in common.split_csv_pairs_generator(segments):
        strata = user_data_stats.Stratum.Strata.add()
        segment_count = strata.Segment.add()
        segment_count.Segment.Keyword = int(keyword)
        segment_count.Segment.ID = int(id)
        segment_count.Count = common.TEST_SEGMENT_COUNT

    affinitive_sites = (
        'гдз.рф_179165.0,balashikha.regmarkets.ru_176001.0,inbalashikha.ru_158704.0,balashiha.tiu.ru_114801.0,'
        'balashikha.cian.ru_92907.0,riamobalashiha.ru_84810.0,pga.gazprombank.ru_39474.0,koleso.ru_38364.0,'
        'mosoblast.rt.ru_35625.0,lkk.mosoblgaz.ru_35154.0,parking.mos.ru_32396.0,rpgu.emias.mosreg.ru_31042.0,'
        'globus.ru_28582.0,dobrodel.mosreg.ru_27132.0,hawk.ru_26595.0,moscow.petrovich.ru_26082.0,'
        'children.school.mosreg.ru_23940.0,xn--90aijkdmaud0d.xn--p1ai_22240.0,uslugi.mosreg.ru_20293.0,'
        'zdorov.ru_19880.0,major-auto.ru_19459.0,vasko.ru_19329.0,topcomputer.ru_19058.0,vamsvet.ru_18680.0,'
        'school.mosreg.ru_18468.0,login.mgts.ru_18128.0,apps.school.mosreg.ru_17985.0,video-shoper.ru_17461.0,'
        'mkb.ru_17280.0,mosreg.ru_17252.0'
    )
    for token, weight in common.split_csv_pairs_generator(affinitive_sites):
        host_affinities = user_data_stats.Affinities.Hosts.Token.add()
        host_affinities.Token = token
        host_affinities.Weight = float(weight)

    affinitive_apps = (
        'ru.apteka_1018141630,com.icemobile.lenta.prod_1012312700,ru.getpharma.eapteka_1008188600,com.edadeal.android_1007379900,'
        'ru.vtb24.collection_1003520830,pyaterochka.app_999293900,ru.ozon.app.android_999002750,'
        'ru.bestprice.fixprice_997483260,com.ru.dixy_994142700,ru.napoleonit.kb_992049100,ru.goods.marketplace_991839040,'
        'com.dartit.RTcabinet_990715200,ru.vkusvill_984113540,ru.hh.android_979298800,ru.burgerking_979237250,'
        'ru.perekrestok.app_974201660,com.gpn.azs_972144300,ru.sovcomcard.halva.v1_970272500,app.source.getcontact_968868000'
    )

    for token, weight in common.split_csv_pairs_generator(affinitive_apps):
        host_affinities = user_data_stats.Affinities.Apps.Token.add()
        host_affinities.Token = token
        host_affinities.Weight = float(weight)

    return user_data_stats


def test_segment_features_calculator():
    user_data_stats = prepare_user_data_stats()
    calculator = segment_features_calculator.TSegmentFeaturesCalculator(common.FEATURES_MAPPING)

    reference_affinitive_sites_ids = get_bytes(
        'гдз.рф balashikha.regmarkets.ru inbalashikha.ru balashiha.tiu.ru balashikha.cian.ru riamobalashiha.ru '
        'pga.gazprombank.ru koleso.ru mosoblast.rt.ru lkk.mosoblgaz.ru parking.mos.ru rpgu.emias.mosreg.ru globus.ru '
        'dobrodel.mosreg.ru hawk.ru moscow.petrovich.ru children.school.mosreg.ru xn--90aijkdmaud0d.xn--p1ai '
        'uslugi.mosreg.ru zdorov.ru'
    )
    reference_affinitive_apps = (
        '1701137006649742528 4415844435471749707 13258630625277259530 2602359023523816535 17070949863655638876 '
        '12832752899727708754 3535685675424256529 1738688780238819464 14665485691697159128 11996346681795636274 '
        '13858740684145194394 16188766909187980536 1629428043334141080 5499112896414709141 10233705656694308248 '
        '6381836103486858947 4315947600988176081 11141851921676273545 11920439166966769960'
    )
    reference_float_features = (
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.100942,0.100942,0.100942,0.100942,0.100942,'
        '0.100942,0.100942,0.00504711,0.644347,0.350606,0.00302826,0.0114401,0.0316285,0.215343,0.403432,0.221736,'
        '0.113392,0.000336474,0.00538358,0.0286003,0.248654,0.585801,0.131225,0.5,0.5,0'
    )

    common.assert_affinities_equal(reference_affinitive_sites_ids.decode('utf-8').split(' '),
                                         calculator.PrepareAffinitiveSitesIds(user_data_stats).decode('utf-8').split(' '))
    common.assert_affinities_equal(reference_affinitive_apps.split(' '),
                                   calculator.PrepareAffinitiveApps(user_data_stats).decode('utf-8').split(' '))
    common.assert_float_features_equal(reference_float_features.split(','),
                                       calculator.PrepareFloatFeatures(user_data_stats).decode('utf-8').split(','))
