from crypta.lib.proto.user_data import enums_pb2
from crypta.lib.proto.user_data import user_data_pb2
from crypta.lookalike.lib.python.utils import user_features_calculator
from crypta.lookalike.lib.python.utils.config import config
from crypta.lookalike.lib.python.utils.test import common


def add_segment(user_data, keyword_id, segment_id, segment_score=1.0):
    segment = user_data.Segments.Segment.add()
    segment.Keyword = keyword_id
    segment.ID = segment_id
    segment.Score = segment_score


def add_affinitive_site(user_data, token, weight):
    affinitive_site = user_data.Affinities.AffinitiveSites.Token.add()
    affinitive_site.Token = token
    affinitive_site.Weight = weight


def add_affinitive_app(user_data, token, weight):
    affinitive_site = user_data.Affinities.Apps.Token.add()
    affinitive_site.Token = token
    affinitive_site.Weight = weight


def add_top_common_site(user_data, token):
    top_common_site = user_data.Affinities.TopCommonSites.Token.add()
    top_common_site.Token = token
    top_common_site.Weight = 1.0


def prepare_user_data():
    user_data = user_data_pb2.TUserData()

    for i in range(config.EMBEDDING_FEATURES_SIZE):
        user_data.Vectors.Vector.Data.append(1)

    user_data.Attributes.Gender = enums_pb2.TGender.FEMALE
    user_data.Attributes.Age = enums_pb2.TAge.UNKNOWN_AGE
    user_data.Attributes.Income = enums_pb2.TIncome.INCOME_B2
    user_data.Attributes.Region = 213

    add_segment(user_data=user_data, keyword_id=546, segment_id=1302, segment_score=0.5)
    add_segment(user_data=user_data, keyword_id=547, segment_id=1058)
    add_segment(user_data=user_data, keyword_id=216, segment_id=616)
    add_segment(user_data=user_data, keyword_id=216, segment_id=549)
    add_segment(user_data=user_data, keyword_id=216, segment_id=560)
    add_segment(user_data=user_data, keyword_id=216, segment_id=555)
    add_segment(user_data=user_data, keyword_id=216, segment_id=562)

    add_affinitive_site(user_data=user_data, token='416215808', weight=0.660682141781)
    add_affinitive_site(user_data=user_data, token='819522304', weight=0.605833292007)
    add_affinitive_site(user_data=user_data, token='1738640396', weight=0.197113588452)
    add_affinitive_site(user_data=user_data, token='321154560', weight=0.528449892998)

    add_affinitive_app(user_data=user_data, token='com.minsvyaz.gosuslugi', weight=104)
    add_affinitive_app(user_data=user_data, token='ru.yandex.uber', weight=130)
    add_affinitive_app(user_data=user_data, token='com.domru.domrutv', weight=37003)
    add_affinitive_app(user_data=user_data, token='com.burgerking.bk', weight=809)

    add_top_common_site(user_data=user_data, token='321154560')
    add_top_common_site(user_data=user_data, token='1738640396')
    add_top_common_site(user_data=user_data, token='2033647617')

    return user_data


def test_user_features_calculator():
    user_data = prepare_user_data()
    calculator = user_features_calculator.TUserFeaturesCalculator(common.FEATURES_MAPPING)

    reference_affinitive_sites_ids = '416215808 819522304 2033647617 1738640396 321154560'
    reference_affinitive_apps = '10346255669534016644 1820054813962352258 13921572392949686720 1169464336012385531'

    reference_float_features = (
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,'
        '0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0.0441942,0,1,1,0,0,0,0.5,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,1,'
        '0,0'
    )

    common.assert_affinities_equal(reference_affinitive_sites_ids.split(' '),
                                         calculator.PrepareAffinitiveSitesIds(user_data).decode().split(' '))
    common.assert_affinities_equal(reference_affinitive_apps.split(' '),
                                         calculator.PrepareAffinitiveApps(user_data).decode().split(' '))
    common.assert_float_features_equal(reference_float_features.split(','),
                                       calculator.PrepareFloatFeatures(user_data).decode().split(','))
