from util.generic.hash cimport THashMap
from util.generic.ptr cimport MakeHolder
from util.generic.string cimport TString

from crypta.lookalike.lib.native.user_features_calculator cimport (
    TUserFeaturesCalculator as TUserFeaturesCalculatorImpl,
    TUserData as TUserDataImpl,
)


cdef class TUserFeaturesCalculator:
    def __init__(self, THashMap[TString, size_t] features_mapping):
        self._impl = MakeHolder[TUserFeaturesCalculatorImpl](features_mapping)

    def PrepareFloatFeatures(self, user_data):
        cdef TUserDataImpl user_data_impl
        user_data_impl.ParseFromString(user_data.SerializeToString())
        return self._impl.Get().PrepareFloatFeatures(user_data_impl)

    def PrepareAffinitiveSitesIds(self, user_data):
        cdef TUserDataImpl user_data_impl
        user_data_impl.ParseFromString(user_data.SerializeToString())
        return self._impl.Get().PrepareAffinitiveSitesIds(user_data_impl)

    def PrepareAffinitiveApps(self, user_data):
        cdef TUserDataImpl user_data_impl
        user_data_impl.ParseFromString(user_data.SerializeToString())
        return self._impl.Get().PrepareAffinitiveApps(user_data_impl)
