from yt import yson

from crypta.lib.python.yt import schema_utils
from crypta.lookalike.lib.python.utils import fields
from crypta.lookalike.proto.cdp_segment_binding_pb2 import TCdpSegmentBinding
from crypta.lookalike.proto.counter_visit_pb2 import TCounterVisit
from crypta.lookalike.proto.goal_achievement_pb2 import TGoalAchievement
from crypta.lookalike.proto.metrika_segment_binding_pb2 import TMetrikaSegmentBinding
from crypta.siberia.bin.custom_audience.ca_builder.proto.ca_binding_pb2 import TCaBinding


def get_goal_audiences_schema():
    schema = schema_utils.get_schema_from_proto(TGoalAchievement, ["goal_id", "ts"])
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = False
    return schema


def get_metrika_segments_schema():
    schema = schema_utils.get_schema_from_proto(TMetrikaSegmentBinding, ["segment_id", "ts"])
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = False
    return schema


def get_metrika_counter_audiences_schema():
    schema = schema_utils.get_schema_from_proto(TCounterVisit, ["counter_id", "ts"])
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = False
    return schema


def get_audience_segments_audiences_schema():
    schema = yson.YsonList([
        {"name": "SegmentID", "type": "int64"},
        {"name": "yandexuid", "type": "uint64"},
    ])
    schema.attributes["strict"] = True
    return schema


def get_cdp_segments_schema():
    schema = schema_utils.get_schema_from_proto(TCdpSegmentBinding, ["segment_id"])
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = False
    return schema


def get_ca_bindings_schema():
    schema = schema_utils.get_schema_from_proto(TCaBinding, ["ca_parent_id"])
    schema.attributes["strict"] = True
    schema.attributes["unique_keys"] = False
    return schema


def get_visit_v2_log_schema():
    schema = [
        {"name": "UserID", "type": "uint64"},
        {"name": "UserIDType", "type": "uint32"},
        {"name": "Goals_ID", "type": "any"},
        {"name": "Goals_EventTime", "type": "any"},
        {"name": "CounterID", "type": "uint32"},
        {"name": "UTCStartTime", "type": "uint32"},
    ]
    schema = yson.YsonList(schema)
    schema.attributes["strict"] = True
    return schema


def get_apps_clustering_schema():
    return {
        fields.bundle_id: 'string',
        fields.cluster_id: 'uint64',
        fields.MD5Hash: 'uint64',
        fields.store_id: 'string',
        fields.centroid_distance: 'double',
        fields.old_cluster_distance: 'double',
    }


def categories_vectors_schema():
    return schema_utils.get_strict_schema(
        [
            {
                "name": fields.cluster_id,
                "type": "int64",
            },
            {
                "name": fields.id_type,
                "type": "string",
            },
            {
                "name": fields.vector,
                "type": "any",
                "type_v3": {"type_name": "optional", "item": {"type_name": "list", "item": "double"}},
            },
        ]
    )


def lal_distances_categories_schema():
    return {
        fields.cryptaId: 'string',
        fields.id_type: 'string',
        fields.cluster_id: 'uint64',
        fields.distance: 'double',
    }


def lal_distances_segments_schema():
    return {
        fields.cryptaId: 'string',
        fields.id_type: 'string',
        fields.group_id: 'string',
        fields.distance: 'double',
    }


def lal_distances_apps_schema():
    return {
        fields.id_type: 'string',
        fields.cryptaId: 'string',
        fields.app_id: 'string',
        fields.MD5Hash: 'uint64',
        fields.distance: 'double',
        fields.label: 'uint64',
        fields.game: 'boolean',
    }


def get_recommendations_table_schema():
    return {
        fields.id_type: 'string',
        fields.cryptaId: 'string',
        fields.top_common_lal_apps: 'any',
        fields.top_common_lal_categories: 'any',
        fields.promoted: 'any',
    }


def get_installers_by_ad_scores_table_schema():
    return {
        fields.id_type: 'string',
        fields.cryptaId: 'string',
        fields.installs_by_ads_scores: 'any',
    }
