#include "calc_goal_audiences_reducer.h"

#include <crypta/lib/native/identifiers/lib/id_types/yandexuid.h>

#include <util/generic/hash_set.h>

using namespace NCrypta::NLookalike::NCalcGoalAudiences;

TCalcGoalAudiencesReducer::TCalcGoalAudiencesReducer(size_t maxAudienceSize)
    : MaxAudienceSize(maxAudienceSize)
{}

void TCalcGoalAudiencesReducer::Do(TReader* reader, TWriter* writer) {
    THashSet<ui64> uniqueYandexuids;
    uniqueYandexuids.reserve(MaxAudienceSize);

    for (; reader->IsValid() && uniqueYandexuids.size() < MaxAudienceSize; reader->Next()) {
        const auto& goalAchievement = reader->GetRow();
        const auto& yandexuid = goalAchievement.GetYandexuid();

        if (!NIdentifiers::TYandexuid::Validate(yandexuid)) {
            continue;
        }

        if (uniqueYandexuids.insert(yandexuid).second) {
            writer->AddRow(goalAchievement);
        }
    }
}

REGISTER_REDUCER(TCalcGoalAudiencesReducer);
