#pragma once

#include <crypta/lookalike/proto/goal_achievement.pb.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NLookalike::NCalcGoalAudiences {
    class TCalcGoalAudiencesReducer : public NYT::IReducer<NYT::TTableReader<TGoalAchievement>, NYT::TTableWriter<TGoalAchievement>> {
    public:
        TCalcGoalAudiencesReducer() = default;
        TCalcGoalAudiencesReducer(size_t maxAudienceSize);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(MaxAudienceSize);

    private:
        size_t MaxAudienceSize = 0;
    };
}
