#include "calc_metrika_counter_audiences_job.h"

#include "calc_metrika_counter_audiences_reducer.h"

#include <crypta/lib/native/range/packs.h>
#include <crypta/lib/native/yql/query_executer/query_executer.h>
#include <crypta/lib/native/yt/processed_tables_tracker/processed_tables_tracker.h>
#include <crypta/lib/native/yt/utils/helpers.h>
#include <crypta/lib/native/yt/utils/timed_yt_path_generator.h>
#include <crypta/lookalike/proto/counter_visit.pb.h>

#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/common.h>
#include <mapreduce/yt/util/temp_table.h>

#include <util/string/join.h>

using namespace NCrypta;
using namespace NCrypta::NLookalike;

int NCalcMetrikaCounterAudiences::CalcMetrikaCounterAudiencesJob(TCalcMetrikaCounterAudiencesJobConfig config, NLog::TLogPtr log) {
    NYT::TConfig::Get()->Pool = config.GetYt().GetPool();

    auto client = NYT::CreateClient(config.GetYt().GetProxy());

    const auto& sourceTables = List(client, config.GetSrcDir(), TListOptions().Absolute(true));
    log->info("List of source tables [\n{}\n]", JoinSeq(",\n", sourceTables));

    const auto sortByFields = {YT_FIELD(TCounterVisit, CounterId), YT_FIELD(TCounterVisit, Ts)};

    const auto& dstTablePath = config.GetDstTable();
    const auto dstTableSchema = NYT::CreateTableSchema<TCounterVisit>(sortByFields);

    for (const auto& pack: GetPacks(sourceTables, config.GetTablePackSize())) {
        auto tx = client->StartTransaction();

        log->info("Processing pack [\n{}\n]", JoinSeq(",\n", pack));

        auto spec = NYT::TMapReduceOperationSpec().SortBy(sortByFields).ReduceBy(YT_FIELD(TCounterVisit, CounterId));
        AddInputs<TCounterVisit>(spec, pack);

        if (tx->Exists(dstTablePath)) {
            spec.AddInput<TCounterVisit>(dstTablePath);
        }

        NYT::TTempTable tmpUnsortedDstTable(tx, "metrika_counter_audiences");
        spec.AddOutput<TCounterVisit>(tmpUnsortedDstTable.Name());

        auto reducer = MakeIntrusive<TCalcMetrikaCounterAudiencesReducer>(config.GetMaxAudienceSize());

        tx->MapReduce(spec, /*mapper*/ nullptr, /*reduceCombiner*/ reducer, /*reducer*/ reducer);

        tx->Sort(NYT::TSortOperationSpec()
                         .SortBy(sortByFields)
                         .AddInput(tmpUnsortedDstTable.Name())
                         .Output(NYT::TRichYPath(dstTablePath).Schema(dstTableSchema).OptimizeFor(NYT::OF_SCAN_ATTR)));

        log->info("Removing processed pack [\n{}\n]", JoinSeq(",\n", pack));
        RemoveTables(tx, pack);

        tx->Commit();
    }

    return 0;
}
