#include "calc_metrika_counter_audiences_reducer.h"

#include <crypta/lib/native/identifiers/lib/id_types/yandexuid.h>

#include <util/generic/hash_set.h>

using namespace NCrypta::NLookalike::NCalcMetrikaCounterAudiences;

TCalcMetrikaCounterAudiencesReducer::TCalcMetrikaCounterAudiencesReducer(size_t maxAudienceSize)
    : MaxAudienceSize(maxAudienceSize)
{}

void TCalcMetrikaCounterAudiencesReducer::Do(TReader* reader, TWriter* writer) {
    THashSet<ui64> uniqueYandexuids;
    uniqueYandexuids.reserve(MaxAudienceSize);

    for (; reader->IsValid() && uniqueYandexuids.size() < MaxAudienceSize; reader->Next()) {
        const auto& counterAchievement = reader->GetRow();
        const auto& yandexuid = counterAchievement.GetYandexuid();

        if (!NIdentifiers::TYandexuid::Validate(yandexuid)) {
            continue;
        }

        if (uniqueYandexuids.insert(yandexuid).second) {
            writer->AddRow(counterAchievement);
        }
    }
}

REGISTER_REDUCER(TCalcMetrikaCounterAudiencesReducer);
