#pragma once

#include <crypta/lookalike/proto/counter_visit.pb.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NLookalike::NCalcMetrikaCounterAudiences {
    class TCalcMetrikaCounterAudiencesReducer : public NYT::IReducer<NYT::TTableReader<TCounterVisit>, NYT::TTableWriter<TCounterVisit>> {
    public:
        TCalcMetrikaCounterAudiencesReducer() = default;
        TCalcMetrikaCounterAudiencesReducer(size_t maxAudienceSize);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(MaxAudienceSize);

    private:
        size_t MaxAudienceSize = 0;
    };
}
