#include "calc_metrika_segments_reducer.h"

#include <crypta/lib/native/identifiers/lib/id_types/yandexuid.h>

#include <util/generic/hash_set.h>

using namespace NCrypta::NLookalike::NCalcMetrikaSegments;

TCalcMetrikaSegmentsReducer::TCalcMetrikaSegmentsReducer(size_t maxAudienceSize)
    : MaxAudienceSize(maxAudienceSize)
{}

void TCalcMetrikaSegmentsReducer::Do(TReader* reader, TWriter* writer) {
    THashSet<ui64> uniqueYandexuids;
    uniqueYandexuids.reserve(MaxAudienceSize);

    for (; reader->IsValid() && uniqueYandexuids.size() < MaxAudienceSize; reader->Next()) {
        const auto& segmentBinding = reader->GetRow();
        const auto& yandexuid = segmentBinding.GetYandexuid();

        if (!NIdentifiers::TYandexuid::Validate(yandexuid)) {
            continue;
        }

        if (uniqueYandexuids.insert(yandexuid).second) {
            writer->AddRow(segmentBinding);
        }
    }
}

REGISTER_REDUCER(TCalcMetrikaSegmentsReducer);
