#pragma once

#include <crypta/lookalike/proto/metrika_segment_binding.pb.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NLookalike::NCalcMetrikaSegments {
    class TCalcMetrikaSegmentsReducer : public NYT::IReducer<NYT::TTableReader<TMetrikaSegmentBinding>, NYT::TTableWriter<TMetrikaSegmentBinding>> {
    public:
        TCalcMetrikaSegmentsReducer() = default;
        TCalcMetrikaSegmentsReducer(size_t maxAudienceSize);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(MaxAudienceSize);

    private:
        size_t MaxAudienceSize = 0;
    };
}
