#include "parse_beh_profile_log_mapper.h"

#include "profile_parse_utils.h"

#include <crypta/lookalike/proto/error.pb.h>
#include <crypta/lookalike/proto/metrika_segment_binding.pb.h>

#include <yabs/proto/user_profile.pb.h>

using namespace NCrypta;
using namespace NCrypta::NLookalike;
using namespace NCrypta::NLookalike::NCalcMetrikaSegments;

const THashMap<NRetargetingIds::EType, TParseBehProfileLogMapper::EOutputTables> TParseBehProfileLogMapper::RetargetingIdType2OutputTable = {
    {NRetargetingIds::EType::MetrikaSegment, TParseBehProfileLogMapper::EOutputTables::MetrikaSegmentBindings},
    {NRetargetingIds::EType::MetrikaEcommerce, TParseBehProfileLogMapper::EOutputTables::MetrikaEcommerceBindings},
    {NRetargetingIds::EType::MobileEvent, TParseBehProfileLogMapper::EOutputTables::MobileEventBindings}
};

TParseBehProfileLogMapper::TParseBehProfileLogMapper(TOutputIndexes outputIndexes)
    : OutputIndexes(std::move(outputIndexes))
{}

void TParseBehProfileLogMapper::Do(TReader* reader, TWriter* writer) {
    for (; reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();
        const auto& uniqId = row.GetUniqId();

        try {
            yabs::proto::Profile profile;
            Y_ENSURE(profile.ParseFromString(row.GetProfileDump()), "Can't parse proto from record value. UniqId = " << uniqId);

            for (const auto& [type, ids] : NProfileParseUtils::GetMetrikaIds(profile)) {
                for (const auto& id : ids) {
                    WriteBindings(writer, RetargetingIdType2OutputTable.at(type), id, uniqId, row.GetTimestamp());
                }
            }
        } catch(const yexception& e) {
            WriteError(writer, TStringBuilder() << "UniqId = " << uniqId << ". Error = " << e.what());
        }
    }
}

void TParseBehProfileLogMapper::WriteBindings(TWriter* writer, EOutputTables table, ui64 id, ui64 yandexuid, ui64 ts) {
    TMetrikaSegmentBinding binding;
    binding.SetSegmentId(id);
    binding.SetYandexuid(yandexuid);
    binding.SetTs(ts);

    writer->AddRow(binding, *OutputIndexes[table]);
}

void TParseBehProfileLogMapper::WriteError(TWriter* writer, const TString& message) {
    TError error;
    error.SetMessage(message);

    writer->AddRow(error, *OutputIndexes[EOutputTables::Errors]);
}

REGISTER_MAPPER(TParseBehProfileLogMapper);
