#pragma once

#include <crypta/lib/native/retargeting_ids/retargeting_id.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <crypta/lookalike/proto/beh_profile_regular_log_entry.pb.h>
#include <crypta/lookalike/proto/metrika_segment_binding.pb.h>
#include <crypta/lookalike/proto/error.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <util/datetime/base.h>
#include <util/generic/hash.h>

namespace NCrypta::NLookalike::NCalcMetrikaSegments {
class TParseBehProfileLogMapper : public NYT::IMapper<NYT::TTableReader<TBehProfileRegularLogEntry>, NYT::TTableWriter<::google::protobuf::Message>> {
    public:
        enum class EOutputTables {
            Errors,
            MetrikaSegmentBindings,
            MetrikaEcommerceBindings,
            MobileEventBindings,
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TParseBehProfileLogMapper() = default;
        TParseBehProfileLogMapper(TOutputIndexes outputIndexes);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(OutputIndexes);

    private:
        void WriteBindings(TWriter* writer, EOutputTables table, ui64 id, ui64 yandexuid, ui64 ts);
        void WriteError(TWriter* writer, const TString& message);

        TOutputIndexes OutputIndexes;

        static const THashMap<NRetargetingIds::EType, EOutputTables> RetargetingIdType2OutputTable;
    };
}
