#include "profile_parse_utils.h"

#include <crypta/lib/native/retargeting_ids/retargeting_id.h>

#include <yabs/server/proto/keywords/keywords_data.pb.h>
#include <yabs/proto/user_profile.pb.h>

using namespace NCrypta;
using namespace NCrypta::NLookalike::NCalcMetrikaSegments;

NProfileParseUtils::TTypeIds NProfileParseUtils::GetMetrikaIds(const yabs::proto::Profile& profile) {
    TTypeIds res;

    for (const auto& item : profile.items()) {
        if (item.keyword_id() == NBSData::NKeywords::KW_VISIT_GOAL) {
            for (const auto& id : item.uint_values()) {
                NRetargetingIds::TRetargetingId retargetingId(id);
                const auto& type = retargetingId.GetType();

                if (type == NRetargetingIds::EType::MetrikaSegment || type == NRetargetingIds::EType::MetrikaEcommerce || type == NRetargetingIds::EType::MobileEvent) {
                    res[type].push_back(retargetingId.GetEntityId());
                }
            }
        }
    }
    return res;
}
