#include <crypta/lookalike/services/calc_metrika_segments/lib/profile_parse_utils.h>

#include <library/cpp/testing/unittest/registar.h>

#include <yabs/server/proto/keywords/keywords_data.pb.h>
#include <yabs/proto/user_profile.pb.h>

using namespace NCrypta;
using namespace NCrypta::NLookalike::NCalcMetrikaSegments::NProfileParseUtils;

Y_UNIT_TEST_SUITE(GetMetrikaSegments) {
    Y_UNIT_TEST(Basic) {
        yabs::proto::Profile profile;

        auto* item1 = profile.add_items();
        item1->set_keyword_id(NBSData::NKeywords::KW_VISIT_GOAL);
        item1->add_uint_values(1);

        auto* item2 = profile.add_items();
        item2->set_keyword_id(NBSData::NKeywords::KW_VISIT_GOAL);
        item2->add_uint_values(1'000'000'000);
        item2->add_uint_values(1'000'000'001);
        item2->add_uint_values(3'000'000'001);

        auto* item3 = profile.add_items();
        item3->set_keyword_id(NBSData::NKeywords::KW_VISIT_GOAL);
        item3->add_uint_values(1'000'000'002);

        auto* item4 = profile.add_items();
        item4->set_keyword_id(236);
        item4->add_uint_values(1'000'000'003);

        auto* item5 = profile.add_items();
        item5->set_keyword_id(NBSData::NKeywords::KW_VISIT_GOAL);
        item5->add_uint_values(999'999'999);

        auto* item6 = profile.add_items();
        item6->set_keyword_id(NBSData::NKeywords::KW_VISIT_GOAL);
        item6->add_uint_values(1'500'000'000);

        auto* item7 = profile.add_items();
        item7->set_keyword_id(NBSData::NKeywords::KW_VISIT_GOAL);

        TTypeIds ref = {
            {NRetargetingIds::EType::MetrikaSegment, {1'000'000'000, 1'000'000'001, 1'000'000'002}},
            {NRetargetingIds::EType::MetrikaEcommerce, {1}}
        };
        UNIT_ASSERT_VALUES_EQUAL(ref, GetMetrikaIds(profile));
    }

    Y_UNIT_TEST(Empty) {
        yabs::proto::Profile profile;
        UNIT_ASSERT(GetMetrikaIds(profile).empty());
    }
}
