#include <crypta/lib/native/log/loggers/std_logger.h>
#include <crypta/lib/native/proto_secrets/remove_secrets.h>
#include <crypta/lib/native/time/shifted_clock.h>
#include <crypta/lib/native/yaml/config/config.h>
#include <crypta/lib/native/yt/utils/timed_yt_path_generator.h>
#include <crypta/lookalike/lib/native/directory_finder.h>
#include <crypta/lookalike/proto/yt_node_names.pb.h>
#include <crypta/lookalike/services/default_user_segments_exporter/proto/default_user_segments_exporter_config.pb.h>

#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/util/ypath_join.h>

#include <util/generic/vector.h>

using namespace NCrypta;
using namespace NCrypta::NLookalike;
using namespace NCrypta::NLookalike::NDefaultUserSegmentsExporter;

int main(int argc, const char** argv) {
    auto log = NLog::NStdLogger::RegisterLog("main", "stdout", "info");
    log->info("================ Start ================");

    try {
        const auto& config = ParseYamlConfig<TDefaultUserSegmentsExporterConfig>(argc, argv);
        log->info("Config:\n{}", NProtoSecrets::GetCopyWithoutSecrets(config).DebugString());

        NYT::TConfig::Get()->Pool = config.GetYt().GetPool();
        auto client = NYT::CreateClient(config.GetYt().GetProxy());
        auto tx = client->StartTransaction();

        const auto& workingDir = NDirectoryFinder::FindLastWithChildren(tx, config.GetVersionsDir(), {TYtNodeNames().GetUserSegmentsTable()});
        log->info("Found last version dir: {}", workingDir);

        const auto& exportTablePath = TTimedYtPathGenerator(TShiftedClock::Now()).GetPath(config.GetExportDir());
        const auto& userSegmentsTablePath = NYT::JoinYPaths(workingDir, TYtNodeNames().GetUserSegmentsTable());

        log->info("Copy from {} to {}", userSegmentsTablePath, exportTablePath);
        tx->Copy(userSegmentsTablePath, exportTablePath, NYT::TCopyOptions().Recursive(true));
        tx->Commit();

        log->info("================ Finish ================");

        return 0;
    } catch (const std::exception& e) {
        log->error("Failed with error: {}", e.what());
    }

    log->info("================ Error ================");

    return 1;
}
