import argparse
import datetime
import functools
import logging

from crypta.lib.python.logging import logging_helpers
from crypta.lookalike.services.features_export.lib import caesar_goal_features


logger = logging.getLogger(__name__)


def main():
    logging_helpers.configure_stderr_logger(logging.getLogger(), level=logging.INFO)
    logger.info('Crypta features export')

    today = str(datetime.date.today())
    tasks_dict = {
        'compute_caesar_goal_features': functools.partial(caesar_goal_features.compute, date=today),
    }

    parser = argparse.ArgumentParser()
    parser.add_argument('job_name', type=str, help=' / '.join(tasks_dict.keys()))
    args = parser.parse_args()

    logger.info('Job name: {}'.format(args.job_name))

    if args.job_name in tasks_dict:
        tasks_dict[args.job_name]()
    else:
        logger.warn('Unknown job_name "{}"'.format(args.job_name))
        exit(1)


if __name__ == '__main__':
    main()
