#include "segment_embeddings_data.h"

using namespace NCrypta::NLookalike;
using namespace NCrypta::NLookalike::NIndexBuilder;

TSegmentEmbeddingsData::TSegmentEmbeddingsData(THnswIndexModel::TLabels&& labels, TBuffer&& buffer)
    : Labels(std::move(labels))
    , Buffer(std::move(buffer))
    , Data(TBlob::NoCopy(Buffer.data(), Buffer.size()))
{
}

const THnswIndexModel::TLabels& TSegmentEmbeddingsData::GetLabels() const {
    return Labels;
};

const TBlob& NCrypta::NLookalike::NIndexBuilder::TSegmentEmbeddingsData::GetData() const {
    return Data;
}

void TSegmentEmbeddingsDataBuilder::AddLabel(const THnswIndexModel::TLabel& label) {
    Labels.push_back(label);
}

void TSegmentEmbeddingsDataBuilder::AddData(const void* data, size_t size) {
    BufferOutput.Write(data, size);
}

TSegmentEmbeddingsData TSegmentEmbeddingsDataBuilder::Build() {
    BufferOutput.Finish();

    return TSegmentEmbeddingsData(std::move(Labels), std::move(BufferOutput.Buffer()));
}
