#pragma once

#include <crypta/lookalike/lib/native/hnsw_index_model.h>

#include <util/memory/blob.h>
#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

namespace NCrypta::NLookalike::NIndexBuilder {
    class TSegmentEmbeddingsData {
    public:
        TSegmentEmbeddingsData(THnswIndexModel::TLabels&& labels, TBuffer&& buffer);

        const THnswIndexModel::TLabels& GetLabels() const;
        const TBlob& GetData() const;

    private:
        THnswIndexModel::TLabels Labels;
        TBuffer Buffer;
        TBlob Data;
    };

    class TSegmentEmbeddingsDataBuilder {
    public:
        void AddLabel(const THnswIndexModel::TLabel& label);
        void AddData(const void* data, size_t size);
        TSegmentEmbeddingsData Build();

    private:
        THnswIndexModel::TLabels Labels;
        TBufferOutput BufferOutput;
    };
}
